package ru.yandex.direct.core.entity.moderation.model.asset;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.creative.model.ModerationInfo;
import ru.yandex.direct.core.entity.moderation.model.BaseModerationData;

@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BannerVideoAdditionModerationData extends BaseModerationData {

    @JsonProperty("preview_url")
    private String previewUrl;

    @JsonProperty("live_preview_url")
    private String livePreviewUrl;

    @JsonProperty("duration")
    private Long duration;

    @JsonProperty("creative_data")
    private ModerationInfo moderationInfo;

    @JsonProperty("social_advertising")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Boolean isSocialAdvertisement;

    public String getPreviewUrl() {
        return previewUrl;
    }

    public void setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
    }

    public String getLivePreviewUrl() {
        return livePreviewUrl;
    }

    public void setLivePreviewUrl(String livePreviewUrl) {
        this.livePreviewUrl = livePreviewUrl;
    }

    public Long getDuration() {
        return duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public ModerationInfo getModerationInfo() {
        return moderationInfo;
    }

    public void setModerationInfo(ModerationInfo moderationInfo) {
        this.moderationInfo = moderationInfo;
    }

    public Boolean getIsSocialAdvertisement() {
        return isSocialAdvertisement;
    }

    public void setIsSocialAdvertisement(Boolean socialAdvertisement) {
        isSocialAdvertisement = socialAdvertisement;
    }
}
