package ru.yandex.direct.core.entity.moderation.model.bannerstorage;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.moderation.model.asset.BannerAssetModerationMeta;

@ParametersAreNonnullByDefault
public class BannerstorageCreativeModerationMeta extends BannerAssetModerationMeta {
    private long creativeId;
    private long creativeVersionId;

    @JsonProperty("creative_id")
    public long getCreativeId() {
        return creativeId;
    }

    public void setCreativeId(long creativeId) {
        this.creativeId = creativeId;
    }

    @JsonProperty("creative_version_id")
    public long getCreativeVersionId() {
        return creativeVersionId;
    }

    public void setCreativeVersionId(long creativeVersionId) {
        this.creativeVersionId = creativeVersionId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BannerstorageCreativeModerationMeta that = (BannerstorageCreativeModerationMeta) o;
        return creativeId == that.creativeId && creativeVersionId == that.creativeVersionId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), creativeId, creativeVersionId);
    }

    @Override
    public String toString() {
        return "BannerstorageCreativeModerationMeta{" +
                "creativeId=" + creativeId +
                ", creativeVersionId=" + creativeVersionId +
                '}' + super.toString();
    }
}
