package ru.yandex.direct.core.entity.moderation.model.bannerstorage;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(value = JsonInclude.Include.NON_NULL)
public class BannerstorageCreativeParameters {
    private int templateId;
    private String templateName;

    private List<String> logo;
    private List<String> backgroundImage;
    private List<String> domainList;
    private List<String> urlSpecialOffer;
    private List<String> buyButtonText;
    private List<String> privacyText;
    private List<String> specialOfferPrivacyText;
    private List<String> specialOfferText;

    // Отображаемая ширина креатива (размеры для адаптивных берутся из таблицы)
    private int width;
    // Отображаемая высота креатива (размеры для адаптивных берутся из таблицы)
    private int height;
    // Ссылка на скриншот
    private String staticPreview;
    // Тип смартового креатива, чтобы модерация умела отличать их у себя (им это важно)
    private SmartCreativeType creativeType;

    @JsonProperty("template_id")
    public int getTemplateId() {
        return templateId;
    }

    public void setTemplateId(int templateId) {
        this.templateId = templateId;
    }

    public BannerstorageCreativeParameters withTemplateId(int templateId) {
        this.templateId = templateId;
        return this;
    }

    @JsonProperty("template_name")
    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public BannerstorageCreativeParameters withTemplateName(String templateName) {
        this.templateName = templateName;
        return this;
    }

    @JsonProperty("logo")
    public List<String> getLogo() {
        return logo;
    }

    public void setLogo(List<String> logo) {
        this.logo = logo;
    }

    public BannerstorageCreativeParameters withLogo(List<String> logo) {
        this.logo = logo;
        return this;
    }

    @JsonProperty("background_image")
    public List<String> getBackgroundImage() {
        return backgroundImage;
    }

    public void setBackgroundImage(List<String> backgroundImage) {
        this.backgroundImage = backgroundImage;
    }

    public BannerstorageCreativeParameters withBackgroundImage(List<String> backgroundImage) {
        this.backgroundImage = backgroundImage;
        return this;
    }

    @JsonProperty("domain_list")
    public List<String> getDomainList() {
        return domainList;
    }

    public void setDomainList(List<String> domainList) {
        this.domainList = domainList;
    }

    public BannerstorageCreativeParameters withDomainList(List<String> domainList) {
        this.domainList = domainList;
        return this;
    }

    @JsonProperty("url_special_offer")
    public List<String> getUrlSpecialOffer() {
        return urlSpecialOffer;
    }

    public void setUrlSpecialOffer(List<String> urlSpecialOffer) {
        this.urlSpecialOffer = urlSpecialOffer;
    }

    public BannerstorageCreativeParameters withUrlSpecialOffer(List<String> urlSpecialOffer) {
        this.urlSpecialOffer = urlSpecialOffer;
        return this;
    }

    @JsonProperty("buy_button_text")
    public List<String> getBuyButtonText() {
        return buyButtonText;
    }

    public void setBuyButtonText(List<String> buyButtonText) {
        this.buyButtonText = buyButtonText;
    }

    public BannerstorageCreativeParameters withBuyButtonText(List<String> buyButtonText) {
        this.buyButtonText = buyButtonText;
        return this;
    }

    @JsonProperty("privacy_text")
    public List<String> getPrivacyText() {
        return privacyText;
    }

    public void setPrivacyText(List<String> privacyText) {
        this.privacyText = privacyText;
    }

    public BannerstorageCreativeParameters withPrivacyText(List<String> privacyText) {
        this.privacyText = privacyText;
        return this;
    }

    @JsonProperty("special_offer_privacy_text")
    public List<String> getSpecialOfferPrivacyText() {
        return specialOfferPrivacyText;
    }

    public void setSpecialOfferPrivacyText(List<String> specialOfferPrivacyText) {
        this.specialOfferPrivacyText = specialOfferPrivacyText;
    }

    public BannerstorageCreativeParameters withSpecialOfferPrivacyText(List<String> specialOfferPrivacyText) {
        this.specialOfferPrivacyText = specialOfferPrivacyText;
        return this;
    }

    @JsonProperty("special_offer_text")
    public List<String> getSpecialOfferText() {
        return specialOfferText;
    }

    public void setSpecialOfferText(List<String> specialOfferText) {
        this.specialOfferText = specialOfferText;
    }

    public BannerstorageCreativeParameters withSpecialOfferText(List<String> specialOfferText) {
        this.specialOfferText = specialOfferText;
        return this;
    }

    @JsonProperty("width")
    public int getWidth() {
        return width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public BannerstorageCreativeParameters withWidth(int width) {
        this.width = width;
        return this;
    }

    @JsonProperty("height")
    public int getHeight() {
        return height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public BannerstorageCreativeParameters withHeight(int height) {
        this.height = height;
        return this;
    }

    @JsonProperty("static_preview")
    public String getStaticPreview() {
        return staticPreview;
    }

    public void setStaticPreview(String staticPreview) {
        this.staticPreview = staticPreview;
    }

    public BannerstorageCreativeParameters withStaticPreview(String staticPreview) {
        this.staticPreview = staticPreview;
        return this;
    }

    @JsonProperty("creative_type")
    public SmartCreativeType getCreativeType() {
        return creativeType;
    }

    public void setCreativeType(SmartCreativeType creativeType) {
        this.creativeType = creativeType;
    }

    public BannerstorageCreativeParameters withCreativeType(SmartCreativeType creativeType) {
        this.creativeType = creativeType;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BannerstorageCreativeParameters that = (BannerstorageCreativeParameters) o;
        return templateId == that.templateId &&
                width == that.width &&
                height == that.height &&
                Objects.equals(templateName, that.templateName) &&
                Objects.equals(logo, that.logo) &&
                Objects.equals(backgroundImage, that.backgroundImage) &&
                Objects.equals(domainList, that.domainList) &&
                Objects.equals(urlSpecialOffer, that.urlSpecialOffer) &&
                Objects.equals(buyButtonText, that.buyButtonText) &&
                Objects.equals(privacyText, that.privacyText) &&
                Objects.equals(specialOfferPrivacyText, that.specialOfferPrivacyText) &&
                Objects.equals(specialOfferText, that.specialOfferText) &&
                Objects.equals(staticPreview, that.staticPreview) &&
                creativeType == that.creativeType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(templateId, templateName, logo, backgroundImage, domainList, urlSpecialOffer,
                buyButtonText, privacyText, specialOfferPrivacyText, specialOfferText, width, height, staticPreview,
                creativeType);
    }

    @Override
    public String toString() {
        return "BannerstorageCreativeParameters{" +
                "templateId=" + templateId +
                ", templateName='" + templateName + '\'' +
                ", logo=" + logo +
                ", backgroundImage=" + backgroundImage +
                ", domainList=" + domainList +
                ", urlSpecialOffer=" + urlSpecialOffer +
                ", buyButtonText=" + buyButtonText +
                ", privacyText=" + privacyText +
                ", specialOfferPrivacyText=" + specialOfferPrivacyText +
                ", specialOfferText=" + specialOfferText +
                ", width=" + width +
                ", height=" + height +
                ", staticPreview='" + staticPreview + '\'' +
                ", creativeType=" + creativeType +
                '}';
    }
}
