package ru.yandex.direct.core.entity.moderation.model.bannerstorage;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.moderation.model.BaseModerationData;

@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BannerstorageCreativeRequestData extends BaseModerationData {
    private String livePreviewUrl;
    private BannerstorageCreativeParameters bannerstorageParams;
    private String geo;

    @JsonProperty("live_preview_url")
    public String getLivePreviewUrl() {
        return livePreviewUrl;
    }

    public void setLivePreviewUrl(String livePreviewUrl) {
        this.livePreviewUrl = livePreviewUrl;
    }

    @JsonProperty("bannerstorage_params")
    public BannerstorageCreativeParameters getBannerstorageParams() {
        return bannerstorageParams;
    }

    public void setBannerstorageParams(BannerstorageCreativeParameters bannerstorageParams) {
        this.bannerstorageParams = bannerstorageParams;
    }

    @JsonProperty("geo")
    public String getGeo() {
        return geo;
    }

    public void setGeo(String geo) {
        this.geo = geo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BannerstorageCreativeRequestData that = (BannerstorageCreativeRequestData) o;
        return Objects.equals(livePreviewUrl, that.livePreviewUrl) &&
                Objects.equals(bannerstorageParams, that.bannerstorageParams) &&
                Objects.equals(geo, that.geo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(livePreviewUrl, bannerstorageParams, geo);
    }

    @Override
    public String toString() {
        return "BannerstorageCreativeRequestData{" +
                "livePreviewUrl='" + livePreviewUrl + '\'' +
                ", bannerstorageParams=" + bannerstorageParams +
                ", geo='" + geo + '\'' +
                "} " + super.toString();
    }
}
