package ru.yandex.direct.core.entity.moderation.model.contentpromotion;

import java.util.List;
import java.util.Objects;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.moderation.model.BannerLink;
import ru.yandex.direct.core.entity.moderation.model.BaseBannerModerationData;

@ParametersAreNonnullByDefault
public class ContentPromotionBannerRequestData extends BaseBannerModerationData {

    private String login;

    /**
     * Ссылка на превью контента
     */
    private String creativePreviewUrl;

    /**
     * Домен кликовой ссылки
     */
    private String domain;

    private List<BannerLink> links;

    /**
     * Идентификатор контента в Директе
     */
    private long creativeId;

    /**
     * Ссылка на продвигаемый контент
     */
    private String contentUrl;

    @JsonProperty("login")
    public String getLogin() {
        return login;
    }

    public ContentPromotionBannerRequestData setLogin(String login) {
        this.login = login;
        return this;
    }

    @JsonProperty("domain")
    public String getDomain() {
        return domain;
    }

    public ContentPromotionBannerRequestData setDomain(@Nullable String domain) {
        this.domain = domain;
        return this;
    }

    @JsonProperty("links")
    public List<BannerLink> getLinks() {
        return links;
    }

    public ContentPromotionBannerRequestData setLinks(List<BannerLink> links) {
        this.links = links;
        return this;
    }

    @JsonProperty("creative_id")
    public long getCreativeId() {
        return creativeId;
    }

    public ContentPromotionBannerRequestData setCreativeId(long creativeId) {
        this.creativeId = creativeId;
        return this;
    }

    @JsonProperty("creative_preview_url")
    public String getCreativePreviewUrl() {
        return creativePreviewUrl;
    }

    public ContentPromotionBannerRequestData setCreativePreviewUrl(String creativePreviewUrl) {
        this.creativePreviewUrl = creativePreviewUrl;
        return this;
    }

    @JsonProperty("content_url")
    public String getContentUrl() {
        return contentUrl;
    }

    public ContentPromotionBannerRequestData setContentUrl(String contentUrl) {
        this.contentUrl = contentUrl;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContentPromotionBannerRequestData)) {
            return false;
        }
        ContentPromotionBannerRequestData that = (ContentPromotionBannerRequestData) o;
        return getCreativeId() == that.getCreativeId() &&
                Objects.equals(getLogin(), that.getLogin()) &&
                Objects.equals(getCreativePreviewUrl(), that.getCreativePreviewUrl()) &&
                Objects.equals(getDomain(), that.getDomain()) &&
                Objects.equals(getLinks(), that.getLinks()) &&
                Objects.equals(getAsSoonAsPossible(), that.getAsSoonAsPossible()) &&
                Objects.equals(getContentUrl(), that.getContentUrl());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getLogin(), getCreativePreviewUrl(), getDomain(), getLinks(), getCreativeId(),
                getContentUrl(), getAsSoonAsPossible());
    }


}
