package ru.yandex.direct.core.entity.moderation.model.contentpromotion;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.moderation.model.AspectRatio;

@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ContentPromotionVideoBannerRequestData extends ContentPromotionBannerRequestData {

    private String title;

    private String body;

    /**
     * Ссылка на видео
     */
    // TODO(dimitrovsd): переехать на поле contentUrl
    private String videoHostingUrl;

    /**
     * Формат видео
     */
    private AspectRatio aspectRatio;

    /**
     * Продолжительность видео в секундах
     */
    private Long duration;

    /**
     * Хост видео (youtube, yandex...)
     */
    private String host;

    @JsonProperty("title")
    public String getTitle() {
        return title;
    }

    public ContentPromotionVideoBannerRequestData setTitle(String title) {
        this.title = title;
        return this;
    }

    @JsonProperty("body")
    public String getBody() {
        return body;
    }

    public ContentPromotionVideoBannerRequestData setBody(String body) {
        this.body = body;
        return this;
    }

    @JsonProperty("aspect_ratio")
    public AspectRatio getAspectRatio() {
        return aspectRatio;
    }

    public ContentPromotionVideoBannerRequestData setAspectRatio(AspectRatio aspectRatio) {
        this.aspectRatio = aspectRatio;
        return this;
    }

    @JsonProperty("video_hosting_url")
    public String getVideoHostingUrl() {
        return videoHostingUrl;
    }

    public void setVideoHostingUrl(String videoHostingUrl) {
        this.videoHostingUrl = videoHostingUrl;
    }

    @JsonProperty("duration")
    public Long getDuration() {
        return duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    @JsonProperty("host")
    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }
}
