package ru.yandex.direct.core.entity.moderation.model.cpm.audio;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.moderation.model.AspectRatio;
import ru.yandex.direct.core.entity.moderation.model.BaseBannerModerationData;

@ParametersAreNonnullByDefault
public class CpmAudioBannerRequestData extends BaseBannerModerationData {

    private String domain;

    private String href;

    private long creativeId;

    private String creativePreviewUrl;

    private String livePreviewUrl;

    private long duration;

    private AspectRatio aspectRatio;

    private String geo;

    @JsonProperty("aspect_ratio")
    public AspectRatio getAspectRatio() {
        return aspectRatio;
    }

    public void setAspectRatio(AspectRatio aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    @JsonProperty("domain")
    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @JsonProperty("href")
    public String getHref() {
        return href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    @JsonProperty("creative_id")
    public long getCreativeId() {
        return creativeId;
    }

    public void setCreativeId(long creativeId) {
        this.creativeId = creativeId;
    }

    @JsonProperty("creative_preview_url")
    public String getCreativePreviewUrl() {
        return creativePreviewUrl;
    }

    public void setCreativePreviewUrl(String creativePreviewUrl) {
        this.creativePreviewUrl = creativePreviewUrl;
    }

    @JsonProperty("live_preview_url")
    public String getLivePreviewUrl() {
        return livePreviewUrl;
    }

    public void setLivePreviewUrl(String livePreviewUrl) {
        this.livePreviewUrl = livePreviewUrl;
    }

    @JsonProperty("duration")
    public long getDuration() {
        return duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    @JsonProperty("geo")
    public String getGeo() {
        return geo;
    }

    public void setGeo(String geo) {
        this.geo = geo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CpmAudioBannerRequestData that = (CpmAudioBannerRequestData) o;
        return creativeId == that.creativeId &&
                duration == that.duration &&
                Objects.equals(domain, that.domain) &&
                Objects.equals(href, that.href) &&
                Objects.equals(creativePreviewUrl, that.creativePreviewUrl) &&
                Objects.equals(livePreviewUrl, that.livePreviewUrl) &&
                Objects.equals(aspectRatio, that.aspectRatio) &&
                Objects.equals(geo, that.geo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(domain, href, creativeId, creativePreviewUrl, livePreviewUrl, duration, aspectRatio, geo);
    }

    @Override
    public String toString() {
        return "CpmAudioBannerRequestData{" +
                "domain='" + domain + '\'' +
                ", href='" + href + '\'' +
                ", creativeId=" + creativeId +
                ", creativePreviewUrl='" + creativePreviewUrl + '\'' +
                ", livePreviewUrl='" + livePreviewUrl + '\'' +
                ", duration=" + duration +
                ", aspectRatio=" + aspectRatio +
                ", geo='" + geo + '\'' +
                '}';
    }
}
