package ru.yandex.direct.core.entity.moderation.model.cpm.canvas;

import java.util.List;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.moderation.model.AspectRatio;
import ru.yandex.direct.core.entity.moderation.model.BannerLink;
import ru.yandex.direct.core.entity.moderation.model.BaseBannerModerationData;
import ru.yandex.direct.core.entity.moderation.model.mobile_content.MobileAppModerationData;

@ParametersAreNonnullByDefault
public class CanvasBannerRequestData extends BaseBannerModerationData {

    /**
     * необязательное поле, в некоторых баннерах отсутствует (banners.domain = null)
     * пример m pr:ppc:all "select * from banners where bid=10751061654\G"
     */
    private String domain;

    /**
     * необязательное поле, в некоторых баннерах отсутствует (banners.href = null)
     * пример m pr:ppc:all "select * from banners where bid=10751061654\G"
     */
    private String href;

    /**
     * обязательное поле (поле-примитив)
     */
    private long creativeId;

    /**
     * Не может быть null, но может быть пустым списком
     */
    private List<BannerLink> links;

    /**
     * обязательное поле (в базе колонка not null)
     */
    private String previewUrl;

    /**
     * обязательное поле, всегда есть в базе для perf_creatives.creative_type='canvas'
     */
    private CanvasModerationInfo moderationInfo;

    /**
     * необязательное поле (не заполняется, если нет href)
     */
    private String parametrizedHref;

    /**
     * обязательное поле (при заполнении упадёт с NPE, если будет null)
     */
    private String geo;

    /**
     * обязательное поле вместе с полями структуры width и height
     * (при заполнении упадёт с NPE, если width или height будет null)
     */
    private AspectRatio aspectRatio;

    /**
     * данные о мобильном приложении
     */
    private MobileAppModerationData mobileContentModerationData;

    @JsonProperty("parametrized_href")
    public String getParametrizedHref() {
        return parametrizedHref;
    }

    public CanvasBannerRequestData setParametrizedHref(String parametrizedHref) {
        this.parametrizedHref = parametrizedHref;
        return this;
    }

    @JsonProperty("creative_data")
    public CanvasModerationInfo getModerationInfo() {
        return moderationInfo;
    }

    public void setModerationInfo(CanvasModerationInfo moderationInfo) {
        this.moderationInfo = moderationInfo;
    }

    @JsonProperty("domain")
    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @JsonProperty("links")
    public List<BannerLink> getLinks() {
        return links;
    }

    public void setLinks(List<BannerLink> links) {
        this.links = links;
    }

    @JsonProperty("href")
    public String getHref() {
        return href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    @JsonProperty("creative_id")
    public long getCreativeId() {
        return creativeId;
    }

    public void setCreativeId(long creativeId) {
        this.creativeId = creativeId;
    }

    @JsonProperty("preview_url")
    public String getPreviewUrl() {
        return previewUrl;
    }

    public void setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
    }

    @JsonProperty("geo")
    public String getGeo() {
        return geo;
    }

    public void setGeo(String geo) {
        this.geo = geo;
    }

    @JsonProperty("aspect_ratio")
    public AspectRatio getAspectRatio() {
        return aspectRatio;
    }

    public void setAspectRatio(AspectRatio aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    @JsonProperty("rmp")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public MobileAppModerationData getMobileContentModerationData() {
        return mobileContentModerationData;
    }

    public void setMobileContentModerationData(MobileAppModerationData mobileContentModerationData) {
        this.mobileContentModerationData = mobileContentModerationData;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CanvasBannerRequestData that = (CanvasBannerRequestData) o;
        return creativeId == that.creativeId &&
                Objects.equals(domain, that.domain) &&
                Objects.equals(links, that.links) &&
                Objects.equals(href, that.href) &&
                Objects.equals(previewUrl, that.previewUrl) &&
                Objects.equals(moderationInfo, that.moderationInfo) &&
                Objects.equals(geo, that.geo) &&
                Objects.equals(aspectRatio, that.aspectRatio) &&
                Objects.equals(mobileContentModerationData, that.mobileContentModerationData);
    }

    @Override
    public int hashCode() {
        return Objects.hash(domain, href, creativeId, links, previewUrl, moderationInfo, geo, aspectRatio,
                mobileContentModerationData);
    }

    @Override
    public String toString() {
        return "CanvasBannerRequestData{" +
                "domain='" + domain + '\'' +
                ", href='" + href + '\'' +
                ", creativeId=" + creativeId +
                ", links=" + links +
                ", previewUrl='" + previewUrl + '\'' +
                ", moderationInfo=" + moderationInfo +
                ", geo='" + geo + '\'' +
                ", aspectRatio=" + aspectRatio +
                ", mobileContentModerationData=" + mobileContentModerationData.toString() +
                '}';
    }
}
