package ru.yandex.direct.core.entity.moderation.model.cpm.frontpage;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.moderation.model.AspectRatio;
import ru.yandex.direct.core.entity.moderation.model.BannerLink;
import ru.yandex.direct.core.entity.moderation.model.BaseBannerModerationData;

@ParametersAreNonnullByDefault
public class CpmYndxFrontpageBannerRequestData extends BaseBannerModerationData {
    private String login;
    private String domain;
    private List<BannerLink> links;
    private long creativeId;
    private String creativePreviewUrl;
    private String livePreviewUrl;
    private AspectRatio aspectRatio;
    private boolean simplePicture;
    private String sourceMediaType;
    private String geo;
    private String currency;
    private String archiveUrl;
    private String campaignType;

    @JsonProperty("login")
    public String getLogin() {
        return login;
    }

    public CpmYndxFrontpageBannerRequestData setLogin(String login) {
        this.login = login;
        return this;
    }

    @JsonProperty("domain")
    public String getDomain() {
        return domain;
    }

    public CpmYndxFrontpageBannerRequestData setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    @JsonProperty("links")
    public List<BannerLink> getLinks() {
        return links;
    }

    public CpmYndxFrontpageBannerRequestData setLinks(List<BannerLink> links) {
        this.links = links;
        return this;
    }

    @JsonProperty("creative_id")
    public long getCreativeId() {
        return creativeId;
    }

    public CpmYndxFrontpageBannerRequestData setCreativeId(long creativeId) {
        this.creativeId = creativeId;
        return this;
    }

    @JsonProperty("creative_preview_url")
    public String getCreativePreviewUrl() {
        return creativePreviewUrl;
    }

    public CpmYndxFrontpageBannerRequestData setCreativePreviewUrl(String creativePreviewUrl) {
        this.creativePreviewUrl = creativePreviewUrl;
        return this;
    }

    @JsonProperty("live_preview_url")
    public String getLivePreviewUrl() {
        return livePreviewUrl;
    }

    public CpmYndxFrontpageBannerRequestData setLivePreviewUrl(String livePreviewUrl) {
        this.livePreviewUrl = livePreviewUrl;
        return this;
    }

    @JsonProperty("simple_picture")
    public boolean isSimplePicture() {
        return simplePicture;
    }

    public CpmYndxFrontpageBannerRequestData setSimplePicture(boolean simplePicture) {
        this.simplePicture = simplePicture;
        return this;
    }

    @JsonProperty("aspect_ratio")
    public AspectRatio getAspectRatio() {
        return aspectRatio;
    }

    public CpmYndxFrontpageBannerRequestData setAspectRatio(AspectRatio aspectRatio) {
        this.aspectRatio = aspectRatio;
        return this;
    }

    @JsonProperty("geo")
    public String getGeo() {
        return geo;
    }

    public CpmYndxFrontpageBannerRequestData setGeo(String geo) {
        this.geo = geo;
        return this;
    }

    @JsonProperty("currency")
    public String getCurrency() {
        return currency;
    }

    public CpmYndxFrontpageBannerRequestData setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    @JsonProperty("source_media_type")
    public String getSourceMediaType() {
        return sourceMediaType;
    }

    public CpmYndxFrontpageBannerRequestData setSourceMediaType(String sourceMediaType) {
        this.sourceMediaType = sourceMediaType;
        return this;
    }

    @JsonProperty("archive_url")
    public String getArchiveUrl() {
        return archiveUrl;
    }

    public CpmYndxFrontpageBannerRequestData setArchiveUrl(String archiveUrl) {
        this.archiveUrl = archiveUrl;
        return this;
    }

    @JsonProperty("campaign_type")
    public String getCampaignType() {
        return campaignType;
    }

    public CpmYndxFrontpageBannerRequestData setCampaignType(String campaignType) {
        this.campaignType = campaignType;
        return this;
    }
}
