package ru.yandex.direct.core.entity.moderation.model.cpm.geopin;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.creative.model.ModerationInfo;
import ru.yandex.direct.core.entity.moderation.model.BaseBannerModerationData;

@ParametersAreNonnullByDefault
public class CpmGeoPinBannerRequestData extends BaseBannerModerationData {

    private long creativeId;

    private long permalinkId;

    private String logo;

    private String name;

    private String description;

    private String image;

    private String buttonLink;

    private String domain;

    private String phone;

    private String creativePreviewUrl;

    private ModerationInfo moderationInfo;

    @JsonProperty("creative_id")
    public long getCreativeId() {
        return creativeId;
    }

    public void setCreativeId(long creativeId) {
        this.creativeId = creativeId;
    }

    @JsonProperty("permalink_id")
    public long getPermalinkId() {
        return permalinkId;
    }

    public void setPermalinkId(long permalinkId) {
        this.permalinkId = permalinkId;
    }

    @JsonProperty("logo")
    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty("image")
    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @JsonProperty("button_link")
    public String getButtonLink() {
        return buttonLink;
    }

    public void setButtonLink(String buttonLink) {
        this.buttonLink = buttonLink;
    }

    @JsonProperty("domain")
    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @JsonProperty("phone")
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    @JsonProperty("creative_preview_url")
    public String getCreativePreviewUrl() {
        return creativePreviewUrl;
    }

    public void setCreativePreviewUrl(String creativePreviewUrl) {
        this.creativePreviewUrl = creativePreviewUrl;
    }

    @JsonProperty("creative_data")
    public ModerationInfo getModerationInfo() {
        return moderationInfo;
    }

    public void setModerationInfo(ModerationInfo moderationInfo) {
        this.moderationInfo = moderationInfo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CpmGeoPinBannerRequestData that = (CpmGeoPinBannerRequestData) o;
        return creativeId == that.creativeId &&
                permalinkId == that.permalinkId &&
                Objects.equals(logo, that.logo) &&
                Objects.equals(name, that.name) &&
                Objects.equals(description, that.description) &&
                Objects.equals(image, that.image) &&
                Objects.equals(buttonLink, that.buttonLink) &&
                Objects.equals(domain, that.domain) &&
                Objects.equals(phone, that.phone) &&
                Objects.equals(creativePreviewUrl, that.creativePreviewUrl) &&
                Objects.equals(moderationInfo, that.moderationInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(creativeId, permalinkId,
                logo, name, description, image,
                buttonLink, domain, phone, creativePreviewUrl,
                moderationInfo);
    }
}
