package ru.yandex.direct.core.entity.moderation.model.cpm.in_banner;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.creative.model.ModerationInfo;
import ru.yandex.direct.core.entity.moderation.model.BaseBannerModerationData;

@ParametersAreNonnullByDefault
public class InBannerRequestData extends BaseBannerModerationData {

    private String domain;

    private String href;

    private long creativeId;

    private String previewUrl;

    private ModerationInfo moderationInfo;

    private String geo;

    private Long width;

    private Long height;

    @JsonProperty("width")
    public Long getWidth() {
        return width;
    }

    public void setWidth(Long width) {
        this.width = width;
    }

    @JsonProperty("height")
    public Long getHeight() {
        return height;
    }

    public void setHeight(Long height) {
        this.height = height;
    }

    @JsonProperty("creative_data")
    public ModerationInfo getModerationInfo() {
        return moderationInfo;
    }

    public void setModerationInfo(ModerationInfo moderationInfo) {
        this.moderationInfo = moderationInfo;
    }

    @JsonProperty("domain")
    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @JsonProperty("href")
    public String getHref() {
        return href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    @JsonProperty("creative_id")
    public long getCreativeId() {
        return creativeId;
    }

    public void setCreativeId(long creativeId) {
        this.creativeId = creativeId;
    }

    @JsonProperty("preview_url")
    public String getPreviewUrl() {
        return previewUrl;
    }

    public void setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
    }

    @JsonProperty("geo")
    public String getGeo() {
        return geo;
    }

    public void setGeo(String geo) {
        this.geo = geo;
    }

    @Override
    public String toString() {
        return "InBannerRequestData{" +
                "domain='" + domain + '\'' +
                ", href='" + href + '\'' +
                ", creativeId=" + creativeId +
                ", previewUrl='" + previewUrl + '\'' +
                ", moderationInfo=" + moderationInfo +
                ", geo='" + geo + '\'' +
                ", width=" + width +
                ", height=" + height +
                "} " + super.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InBannerRequestData that = (InBannerRequestData) o;
        return creativeId == that.creativeId &&
                Objects.equals(domain, that.domain) &&
                Objects.equals(href, that.href) &&
                Objects.equals(previewUrl, that.previewUrl) &&
                Objects.equals(moderationInfo, that.moderationInfo) &&
                Objects.equals(geo, that.geo) &&
                Objects.equals(width, that.width) &&
                Objects.equals(height, that.height);
    }

    @Override
    public int hashCode() {
        return Objects.hash(domain, href, creativeId, previewUrl, moderationInfo, geo, width, height);
    }

}
