package ru.yandex.direct.core.entity.moderation.model.cpm.video;

import java.util.List;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.creative.model.ModerationInfo;
import ru.yandex.direct.core.entity.moderation.model.BannerLink;
import ru.yandex.direct.core.entity.moderation.model.BaseBannerModerationData;
import ru.yandex.direct.core.entity.moderation.model.mobile_content.MobileAppModerationData;

@ParametersAreNonnullByDefault
public class CpmVideoBannerRequestData extends BaseBannerModerationData {

    private String domain;

    private String body;

    private String title;

    private String titleExtension;

    private String href;

    private long creativeId;

    private String previewUrl;

    private ModerationInfo moderationInfo;

    private String geo;

    private MobileAppModerationData mobileContentModerationData;

    private List<BannerLink> links;

    @JsonProperty("creative_data")
    public ModerationInfo getModerationInfo() {
        return moderationInfo;
    }

    public void setModerationInfo(ModerationInfo moderationInfo) {
        this.moderationInfo = moderationInfo;
    }

    @JsonProperty("domain")
    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @JsonProperty("body")
    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    @JsonProperty("title")
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty("title_extension")
    public String getTitleExtension() {
        return titleExtension;
    }

    public void setTitleExtension(String titleExtension) {
        this.titleExtension = titleExtension;
    }

    @JsonProperty("href")
    public String getHref() {
        return href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    @JsonProperty("creative_id")
    public long getCreativeId() {
        return creativeId;
    }

    public void setCreativeId(long creativeId) {
        this.creativeId = creativeId;
    }

    @JsonProperty("preview_url")
    public String getPreviewUrl() {
        return previewUrl;
    }

    public void setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
    }

    @JsonProperty("geo")
    public String getGeo() {
        return geo;
    }

    public void setGeo(String geo) {
        this.geo = geo;
    }

    @JsonProperty("rmp")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public MobileAppModerationData getMobileContentModerationData() {
        return mobileContentModerationData;
    }

    public void setMobileContentModerationData(MobileAppModerationData mobileContentModerationData) {
        this.mobileContentModerationData = mobileContentModerationData;
    }

    @JsonProperty("links")
    public List<BannerLink> getLinks() {
        return links;
    }

    public void setLinks(List<BannerLink> links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CpmVideoBannerRequestData that = (CpmVideoBannerRequestData) o;
        return creativeId == that.creativeId &&
                Objects.equals(domain, that.domain) &&
                Objects.equals(body, that.body) &&
                Objects.equals(title, that.title) &&
                Objects.equals(titleExtension, that.titleExtension) &&
                Objects.equals(href, that.href) &&
                Objects.equals(previewUrl, that.previewUrl) &&
                Objects.equals(moderationInfo, that.moderationInfo) &&
                Objects.equals(geo, that.geo) &&
                Objects.equals(mobileContentModerationData, that.mobileContentModerationData) &&
                Objects.equals(links, that.links);
    }

    @Override
    public int hashCode() {
        return Objects.hash(domain, body, title, titleExtension, href, creativeId, previewUrl, moderationInfo, geo,
                mobileContentModerationData, links);
    }

    @Override
    public String toString() {
        return "CpmVideoBannerRequestData{" +
                "domain='" + domain + '\'' +
                ", body='" + body + '\'' +
                ", title='" + title + '\'' +
                ", titleExtension='" + titleExtension + '\'' +
                ", href='" + href + '\'' +
                ", creativeId=" + creativeId +
                ", previewUrl='" + previewUrl + '\'' +
                ", moderationInfo=" + moderationInfo +
                ", geo='" + geo + '\'' +
                ", mobileContentModerationData='" + mobileContentModerationData.toString() + '\'' +
                ", links='" + links + '\'' +
                '}';
    }
}
