package ru.yandex.direct.core.entity.moderation.model.displayhrefs;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.moderation.model.asset.BannerAssetModerationMeta;

@ParametersAreNonnullByDefault
public class DisplayHrefsModerationMeta extends BannerAssetModerationMeta {

    @JsonProperty("display_href_id")
    private long displayHrefId;

    public long getDisplayHrefId() {
        return displayHrefId;
    }

    public DisplayHrefsModerationMeta setDisplayHrefId(long displayHrefId) {
        this.displayHrefId = displayHrefId;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DisplayHrefsModerationMeta that = (DisplayHrefsModerationMeta) o;
        return displayHrefId == that.displayHrefId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), displayHrefId);
    }

    @Override
    public String toString() {
        return "DisplayHrefsModerationMeta{" +
                "displayHrefId=" + displayHrefId +
                '}' + super.toString();
    }
}
