package ru.yandex.direct.core.entity.moderation.model.html5;

import java.util.List;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.moderation.model.AspectRatio;
import ru.yandex.direct.core.entity.moderation.model.BannerLink;
import ru.yandex.direct.core.entity.moderation.model.BaseBannerModerationData;
import ru.yandex.direct.core.entity.moderation.model.mobile_content.MobileAppModerationData;

@ParametersAreNonnullByDefault
public class Html5BannerRequestData extends BaseBannerModerationData {
    /**
     * Может быть null
     */
    private String domain;

    /**
     * обязательное поле (примитив)
     */
    private long creativeId;

    /**
     * Не может быть null, но может быть пустым списком
     */
    private List<BannerLink> links;

    /**
     * обязательное поле (в базе колонка not null)
     */
    private String previewUrl;

    /**
     * обязательное поле (при заполнении упадёт с NPE, если будет null)
     */
    private String geo;

    /**
     * обязательное поле (присутствует для всех креативов с creative_type='html5_creative')
     */
    private String archiveUrl;

    /**
     * обязательное поле (присутствует для всех креативов с creative_type='html5_creative')
     */
    private String livePreviewUrl;

    /**
     * обязательное поле вместе с полями структуры width и height
     * (при заполнении упадёт с NPE, если width или height будет null)
     */
    private AspectRatio aspectRatio;

    /**
     * обязательное поле (примитив)
     */
    private boolean simplePicture;

    /**
     * данные о мобильном приложении
     */
    private MobileAppModerationData mobileContentModerationData;

    @JsonProperty("domain")
    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @JsonProperty("links")
    public List<BannerLink> getLinks() {
        return links;
    }

    public void setLinks(List<BannerLink> links) {
        this.links = links;
    }

    @JsonProperty("creative_id")
    public long getCreativeId() {
        return creativeId;
    }

    public void setCreativeId(long creativeId) {
        this.creativeId = creativeId;
    }

    @JsonProperty("preview_url")
    public String getPreviewUrl() {
        return previewUrl;
    }

    public void setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
    }

    @JsonProperty("archive_url")
    public String getArchiveUrl() {
        return archiveUrl;
    }

    public void setArchiveUrl(String archiveUrl) {
        this.archiveUrl = archiveUrl;
    }

    @JsonProperty("live_preview_url")
    public String getLivePreviewUrl() {
        return livePreviewUrl;
    }

    public void setLivePreviewUrl(String livePreviewUrl) {
        this.livePreviewUrl = livePreviewUrl;
    }

    @JsonProperty("aspect_ratio")
    public AspectRatio getAspectRatio() {
        return aspectRatio;
    }

    public void setAspectRatio(AspectRatio aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    @JsonProperty("simple_picture")
    public boolean getSimplePicture() {
        return simplePicture;
    }

    public void setSimplePicture(boolean simplePicture) {
        this.simplePicture = simplePicture;
    }

    @JsonProperty("geo")
    public String getGeo() {
        return geo;
    }

    public void setGeo(String geo) {
        this.geo = geo;
    }

    @JsonProperty("rmp")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public MobileAppModerationData getMobileContentModerationData() {
        return mobileContentModerationData;
    }

    public void setMobileContentModerationData(MobileAppModerationData mobileContentModerationData) {
        this.mobileContentModerationData = mobileContentModerationData;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Html5BannerRequestData that = (Html5BannerRequestData) o;
        return creativeId == that.creativeId &&
                Objects.equals(simplePicture, that.simplePicture) &&
                Objects.equals(domain, that.domain) &&
                Objects.equals(links, that.links) &&
                Objects.equals(previewUrl, that.previewUrl) &&
                Objects.equals(geo, that.geo) &&
                Objects.equals(archiveUrl, that.archiveUrl) &&
                Objects.equals(livePreviewUrl, that.livePreviewUrl) &&
                Objects.equals(aspectRatio, that.aspectRatio) &&
                Objects.equals(mobileContentModerationData, that.mobileContentModerationData);
    }

    @Override
    public int hashCode() {
        return Objects.hash(domain, creativeId, links, previewUrl, geo, archiveUrl, livePreviewUrl, aspectRatio,
                simplePicture, mobileContentModerationData);
    }

    @Override
    public String toString() {
        return "Html5BannerRequestData{" +
                "domain='" + domain + '\'' +
                ", creativeId=" + creativeId +
                ", links=" + links +
                ", previewUrl='" + previewUrl + '\'' +
                ", geo='" + geo + '\'' +
                ", archiveUrl='" + archiveUrl + '\'' +
                ", livePreviewUrl='" + livePreviewUrl + '\'' +
                ", aspectRatio=" + aspectRatio +
                ", simplePicture=" + simplePicture +
                ", mobileContentModerationData=" + mobileContentModerationData.toString() +
                '}';
    }
}
