package ru.yandex.direct.core.entity.moderation.model.image;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.moderation.model.BaseModerationData;
import ru.yandex.direct.dbschema.ppc.enums.CampaignsType;

@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ImageRequestData extends BaseModerationData {

    private String host;
    private String imageHash;
    private Integer mdsGroupId;
    private String namespace;
    private String name;
    private CampaignsType campaignType;

    @JsonProperty("host")
    public String getHost() {
        return host;
    }

    public ImageRequestData setHost(String host) {
        this.host = host;
        return this;
    }

    @JsonProperty("image_hash")
    public String getImageHash() {
        return imageHash;
    }

    public ImageRequestData setImageHash(String imageHash) {
        this.imageHash = imageHash;
        return this;
    }

    @JsonProperty("mds_group_id")
    public Integer getMdsGroupId() {
        return mdsGroupId;
    }

    public ImageRequestData setMdsGroupId(Integer mdsGroupId) {
        this.mdsGroupId = mdsGroupId;
        return this;
    }

    @JsonProperty("namespace")
    public String getNamespace() {
        return namespace;
    }

    public ImageRequestData setNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    public ImageRequestData setName(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty("direct_campaign_type")
    public CampaignsType getCampaignType() {
        return campaignType;
    }

    public void setCampaignType(CampaignsType campaignType) {
        this.campaignType = campaignType;
    }
}
