package ru.yandex.direct.core.entity.moderation.model.mobilecontenticon;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.moderation.model.BaseModerationData;
import ru.yandex.direct.dbschema.ppc.enums.MobileContentContentType;
import ru.yandex.direct.dbschema.ppc.enums.MobileContentOsType;

@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class MobileContentIconModerationData extends BaseModerationData {
    private MobileContentContentType contentType;
    private String iconUrl;
    private String name;
    private MobileContentOsType osType;
    private String storeAppId;
    private String storeCountry;
    private String storeName;

    @JsonProperty("content_type")
    public MobileContentContentType getContentType() {
        return contentType;
    }

    public void setContentType(MobileContentContentType contentType) {
        this.contentType = contentType;
    }

    @JsonProperty("icon_url")
    public String getIconUrl() {
        return iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty("os_type")
    public MobileContentOsType getOsType() {
        return osType;
    }

    public void setOsType(MobileContentOsType osType) {
        this.osType = osType;
    }

    @JsonProperty("store_app_id")
    public String getStoreAppId() {
        return storeAppId;
    }

    public void setStoreAppId(String storeAppId) {
        this.storeAppId = storeAppId;
    }

    @JsonProperty("store_country")
    public String getStoreCountry() {
        return storeCountry;
    }

    public void setStoreCountry(String storeCountry) {
        this.storeCountry = storeCountry;
    }

    @JsonProperty("store_name")
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
}
