package ru.yandex.direct.core.entity.moderation.model.promoextension

import com.fasterxml.jackson.annotation.JsonProperty
import ru.yandex.direct.core.entity.moderation.model.AbstractModerationResultResponse
import ru.yandex.direct.core.entity.moderation.model.BaseModerationData
import ru.yandex.direct.core.entity.moderation.model.BaseModerationMeta
import ru.yandex.direct.core.entity.moderation.model.ModerationRequestWithData
import ru.yandex.direct.core.entity.moderation.model.Verdict

/**
 * формат фиксировался в https://st.yandex-team.ru/MODDEV-3052
 */


class PromoExtensionModerationRequestData(
    @JsonProperty("description")
    val description: String,
    @JsonProperty("href")
    val href: String?,
    @JsonProperty("parametrized_href")
    val parametrizedHref: String?,
    @JsonProperty("domain")
    val domain: String?,
    @JsonProperty("promocode")
    val promocode: String?,
): BaseModerationData()

class PromoExtensionModerationRequest
    : ModerationRequestWithData<PromoExtensionModerationMeta, PromoExtensionModerationRequestData>()

class PromoExtensionModerationMeta (
    @JsonProperty("promo_extension_id")
    val promoExtensionId: Long,
    uid: Long,
    clientId: Long,
    versionId: Long,
) : BaseModerationMeta() {
    init {
        setUid(uid)
        setClientId(clientId)
        setVersionId(versionId)
    }
}

class PromoExtensionModerationResponse
    : AbstractModerationResultResponse<PromoExtensionModerationMeta?, Verdict?>() {
    private var result: Verdict? = null

    override fun getResult() = result

    fun setResult(result: Verdict?) {
        this.result = result
    }
}
