package ru.yandex.direct.core.entity.moderation.model.sitelinks;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.moderation.model.asset.BannerAssetModerationMeta;

@ParametersAreNonnullByDefault
public class SitelinksModerationMeta extends BannerAssetModerationMeta {

    @JsonProperty("sitelinks_set_id")
    private long sitelinksSetId;

    public long getSitelinksSetId() {
        return sitelinksSetId;
    }

    public SitelinksModerationMeta setSitelinksSetId(long sitelinksSetId) {
        this.sitelinksSetId = sitelinksSetId;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SitelinksModerationMeta that = (SitelinksModerationMeta) o;
        return sitelinksSetId == that.sitelinksSetId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), sitelinksSetId);
    }

    @Override
    public String toString() {
        return "SitelinksModerationMeta{" +
                "sitelinksSetId=" + sitelinksSetId +
                '}' + super.toString();
    }
}
