package ru.yandex.direct.core.entity.moderation.model.sitelinks;

import java.util.List;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.moderation.model.BaseModerationData;

@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class SitelinksRequestData extends BaseModerationData {

    @JsonProperty("sitelinks")
    private List<SitelinkRequest> sitelinkRequestList;

    public List<SitelinkRequest> getSitelinkRequestList() {
        return sitelinkRequestList;
    }

    public SitelinksRequestData setSitelinkRequestList(List<SitelinkRequest> sitelinkRequestList) {
        this.sitelinkRequestList = sitelinkRequestList;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SitelinksRequestData that = (SitelinksRequestData) o;
        return Objects.equals(sitelinkRequestList, that.sitelinkRequestList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sitelinkRequestList);
    }

    public static class SitelinkRequest {
        @JsonProperty("title")
        private String title;

        @JsonProperty("description")
        private String description;

        @JsonProperty("href")
        private String href;

        @JsonProperty("parametrized_href")
        private String parametrizedHref;

        @JsonProperty("sitelink_id")
        private Long sitelinkId;

        @JsonProperty("turbolink_href")
        private String turbolinkHref;

        @JsonProperty("turbolink_id")
        private Long turbolinkId;

        public String getTitle() {
            return title;
        }

        public SitelinkRequest setTitle(String title) {
            this.title = title;
            return this;
        }

        public String getDescription() {
            return description;
        }

        public SitelinkRequest setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getHref() {
            return href;
        }

        public SitelinkRequest setHref(String href) {
            this.href = href;
            return this;
        }

        public String getParametrizedHref() {
            return parametrizedHref;
        }

        public SitelinkRequest setParametrizedHref(String parametrizedHref) {
            this.parametrizedHref = parametrizedHref;
            return this;
        }

        public Long getSitelinkId() {
            return sitelinkId;
        }

        public SitelinkRequest setSitelinkId(Long sitelinkId) {
            this.sitelinkId = sitelinkId;
            return this;
        }

        public String getTurbolinkHref() {
            return turbolinkHref;
        }

        public SitelinkRequest setTurbolinkHref(String turbolinkHref) {
            this.turbolinkHref = turbolinkHref;
            return this;
        }

        public Long getTurbolinkId() {
            return turbolinkId;
        }

        public SitelinkRequest setTurbolinkId(Long turbolinkId) {
            this.turbolinkId = turbolinkId;
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || getClass() != o.getClass()) {
                return false;
            }
            SitelinkRequest that = (SitelinkRequest) o;
            return Objects.equals(title, that.title) &&
                    Objects.equals(description, that.description) &&
                    Objects.equals(href, that.href) &&
                    Objects.equals(parametrizedHref, that.parametrizedHref) &&
                    Objects.equals(sitelinkId, that.sitelinkId) &&
                    Objects.equals(turbolinkHref, that.turbolinkHref) &&
                    Objects.equals(turbolinkId, that.turbolinkId);
        }

        @Override
        public int hashCode() {
            return Objects.hash(title, description, href, parametrizedHref, sitelinkId, turbolinkHref, turbolinkId);
        }
    }
}
