package ru.yandex.direct.core.entity.moderation.model.text;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.moderation.model.BaseBannerModerationData;
import ru.yandex.direct.core.entity.moderation.model.mobile_content.MobileAppModerationData;

@ParametersAreNonnullByDefault
public class TextBannerRequestData extends BaseBannerModerationData {
    private String body;
    private String title;
    private String titleExtension;
    private String language;
    private String domain;
    private String href;
    private String parametrizedHref;
    private String turboHref;
    private String geo;
    private Long permalink;
    private MobileAppModerationData mobileContentModerationData;

    @JsonProperty("body")
    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    @JsonProperty("title")
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty("title_extension")
    public String getTitleExtension() {
        return titleExtension;
    }

    public void setTitleExtension(String titleExtension) {
        this.titleExtension = titleExtension;
    }

    @JsonProperty("lang")
    public String getLanguage() {
        return language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    @JsonProperty("domain")
    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @JsonProperty("href")
    public String getHref() {
        return href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    @JsonProperty("parametrized_href")
    public String getParametrizedHref() {
        return parametrizedHref;
    }

    public void setParametrizedHref(String parametrizedHref) {
        this.parametrizedHref = parametrizedHref;
    }

    @JsonProperty("turbo_href")
    public String getTurboHref() {
        return turboHref;
    }

    public void setTurboHref(String turboHref) {
        this.turboHref = turboHref;
    }

    @JsonProperty("geo")
    public String getGeo() {
        return geo;
    }

    public void setGeo(String geo) {
        this.geo = geo;
    }


    public Long getPermalink() {
        return permalink;
    }

    @JsonProperty("permalink")
    public void setPermalink(Long permalink) {
        this.permalink = permalink;
    }

    @JsonProperty("rmp")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public MobileAppModerationData getMobileContentModerationData() {
        return mobileContentModerationData;
    }

    public void setMobileContentModerationData(MobileAppModerationData mobileContentModerationData) {
        this.mobileContentModerationData = mobileContentModerationData;
    }
}
