package ru.yandex.direct.core.entity.moderation.model.turbolandings;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.moderation.model.asset.BannerAssetModerationMeta;

@ParametersAreNonnullByDefault
public class TurbolandingModerationMeta extends BannerAssetModerationMeta {

    @JsonProperty("tl_id")
    private long tlId;

    public long getTlId() {
        return tlId;
    }

    public TurbolandingModerationMeta setTlId(long tlId) {
        this.tlId = tlId;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TurbolandingModerationMeta that = (TurbolandingModerationMeta) o;
        return tlId == that.tlId;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), tlId);
    }

    @Override
    public String toString() {
        return "TurbolandingModerationMeta{" +
                "tlId=" + tlId +
                '}';
    }
}
