package ru.yandex.direct.core.entity.moderation.model.verdictrequest;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.moderation.model.ModerationMeta;
import ru.yandex.direct.core.entity.moderation.model.ModerationRequest;

/**
 * Запрос ответа модерации в формате, который требует от нас команда Модерации.
 */
public class ModerationVerdictRequest<BannerModerationMetaT extends ModerationMeta, ModerationVerdictT> extends ModerationRequest<BannerModerationMetaT> {

    private ModerationVerdictT verdict;

    // Идентификатор источника вердикта. Из того что есть: antispam/yang/toloka/admin/
    // angel (перловый автомодератор)/lyncher (питонячий автомодератор)...
    private String circuit;

    @JsonProperty("verdict")
    public ModerationVerdictT getVerdict() {
        return verdict;
    }

    public void setVerdict(ModerationVerdictT verdict) {
        this.verdict = verdict;
    }

    @JsonProperty("circuit")
    public String getCircuit() {
        return circuit;
    }

    public void setCircuit(String circuit) {
        this.circuit = circuit;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModerationVerdictRequest<?, ?> that = (ModerationVerdictRequest<?, ?>) o;
        return Objects.equals(verdict, that.verdict);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), verdict, circuit);
    }

    @Override
    public String toString() {
        return "ModerationVerdictRequest{" +
                "verdict=" + verdict +
                ", circuit='" + circuit + '\'' +
                '}';
    }
}
