package ru.yandex.direct.core.entity.moderation.model.verdictrequest.contentpromotion;

import java.util.Objects;

public class ContentPromotionAccessibilityData {

    private final Long contentPromotionId;
    private final Boolean isInaccessible;

    public ContentPromotionAccessibilityData(Long contentPromotionId, Boolean isInaccessible) {
        this.contentPromotionId = contentPromotionId;
        this.isInaccessible = isInaccessible;
    }

    public Long getContentPromotionId() {
        return contentPromotionId;
    }

    public Boolean getIsInaccessible() {
        return isInaccessible;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ContentPromotionAccessibilityData that = (ContentPromotionAccessibilityData) o;
        return Objects.equals(contentPromotionId, that.contentPromotionId) &&
                Objects.equals(isInaccessible, that.isInaccessible);
    }

    @Override
    public int hashCode() {
        return Objects.hash(contentPromotionId, isInaccessible);
    }
}
