package ru.yandex.direct.core.entity.moderation.model.verdictrequest.contentpromotion;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

import static java.util.Collections.emptyList;
import static java.util.Collections.singletonList;

public class ContentPromotionModerationVerdict {

    private static final ContentPromotionModerationVerdict MODERATION_VERDICT_INACCESSIBLE =
            new ContentPromotionModerationVerdict(true);
    private static final ContentPromotionModerationVerdict MODERATION_VERDICT_ACCESSIBLE =
            new ContentPromotionModerationVerdict(false);

    private String verdict;
    private List<Long> reasons;

    private ContentPromotionModerationVerdict(boolean isInaccessible) {
        verdict = isInaccessible ? "No" : "Yes";
        reasons = isInaccessible ? singletonList(1059L) : emptyList();
    }

    public static ContentPromotionModerationVerdict getContentPromotionModerationVerdict(boolean isInaccessible) {
        return isInaccessible ? MODERATION_VERDICT_INACCESSIBLE : MODERATION_VERDICT_ACCESSIBLE;
    }

    @JsonProperty("verdict")
    public String getVerdict() {
        return verdict;
    }

    @JsonProperty("reasons")
    public List<Long> getReasons() {
        return reasons;
    }
}
