package ru.yandex.direct.core.entity.moderation.repository;

import java.util.Collection;

import org.jooq.util.mysql.MySQLDSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.moderation.model.ModResyncQueueObj;
import ru.yandex.direct.core.entity.moderation.model.ModResyncQueueObjectType;
import ru.yandex.direct.dbschema.ppc.tables.records.ModResyncQueueRecord;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplier;
import ru.yandex.direct.jooqmapper.JooqMapperWithSupplierBuilder;
import ru.yandex.direct.jooqmapperhelper.InsertHelper;

import static ru.yandex.direct.common.jooqmapperex.ReaderWriterBuildersEx.booleanProperty;
import static ru.yandex.direct.core.entity.moderation.model.ModResyncQueueObj.ADD_TIME;
import static ru.yandex.direct.core.entity.moderation.model.ModResyncQueueObj.ID;
import static ru.yandex.direct.core.entity.moderation.model.ModResyncQueueObj.OBJECT_ID;
import static ru.yandex.direct.core.entity.moderation.model.ModResyncQueueObj.OBJECT_TYPE;
import static ru.yandex.direct.core.entity.moderation.model.ModResyncQueueObj.PRIORITY;
import static ru.yandex.direct.core.entity.moderation.model.ModResyncQueueObj.REMODERATE;
import static ru.yandex.direct.dbschema.ppc.tables.ModResyncQueue.MOD_RESYNC_QUEUE;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.convertibleProperty;
import static ru.yandex.direct.jooqmapper.ReaderWriterBuilders.property;

@Repository
public class ModResyncQueueRepository {

    private final DslContextProvider dslContextProvider;
    private final JooqMapperWithSupplier<ModResyncQueueObj> mapper;

    @Autowired
    public ModResyncQueueRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
        this.mapper = createMapper();
    }

    public JooqMapperWithSupplier<ModResyncQueueObj> getMapper() {
        return mapper;
    }

    public void add(int shard, Collection<ModResyncQueueObj> modResyncQueueObjects) {
        if (modResyncQueueObjects.isEmpty()) {
            return;
        }

        InsertHelper<ModResyncQueueRecord> insertHelper =
                new InsertHelper<>(dslContextProvider.ppc(shard), MOD_RESYNC_QUEUE);
        modResyncQueueObjects.forEach(obj -> {
            insertHelper.add(mapper, obj)
                    .set(MOD_RESYNC_QUEUE.ADD_TIME, MySQLDSL.currentLocalDateTime())
                    .newRecord();
        });

        insertHelper.onDuplicateKeyUpdate()
                .set(MOD_RESYNC_QUEUE.PRIORITY, MySQLDSL.values(MOD_RESYNC_QUEUE.PRIORITY))
                .set(MOD_RESYNC_QUEUE.REMODERATE, MySQLDSL.values(MOD_RESYNC_QUEUE.REMODERATE))
                .executeIfRecordsAdded();
    }

    private JooqMapperWithSupplier<ModResyncQueueObj> createMapper() {
        return JooqMapperWithSupplierBuilder.builder(ModResyncQueueObj::new)
                .map(property(ID, MOD_RESYNC_QUEUE.ID))
                .map(property(OBJECT_ID, MOD_RESYNC_QUEUE.OBJECT_ID))
                .map(convertibleProperty(OBJECT_TYPE, MOD_RESYNC_QUEUE.OBJECT_TYPE,
                        ModResyncQueueObjectType::fromSource, ModResyncQueueObjectType::toSource))
                .map(property(PRIORITY, MOD_RESYNC_QUEUE.PRIORITY))
                .map(booleanProperty(REMODERATE, MOD_RESYNC_QUEUE.REMODERATE))
                .map(property(ADD_TIME, MOD_RESYNC_QUEUE.ADD_TIME))
                .build();
    }
}
