package ru.yandex.direct.core.entity.moderation.repository.receiving;

import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.moderation.model.TransportStatus;
import ru.yandex.direct.core.entity.moderation.repository.sending.TransportStatusAdapter;
import ru.yandex.direct.dbschema.ppc.enums.BannerButtonsStatusmoderate;
import ru.yandex.direct.dbschema.ppc.tables.records.BannerButtonsRecord;

import static ru.yandex.direct.dbschema.ppc.tables.BannerButtons.BANNER_BUTTONS;
import static ru.yandex.direct.dbschema.ppc.tables.BannerButtonsModerationVersions.BANNER_BUTTONS_MODERATION_VERSIONS;

@Repository
public class BannerButtonModerationReceivingRepository extends ModerationReceivingRepositorySingleKey<BannerButtonsRecord,
        BannerButtonsStatusmoderate> {
    public BannerButtonModerationReceivingRepository() {
        super(BANNER_BUTTONS.BID, BANNER_BUTTONS_MODERATION_VERSIONS.VERSION,
                BANNER_BUTTONS.STATUS_MODERATE);
    }

    @Override
    BannerButtonsStatusmoderate transportStatusMap(TransportStatus transportStatus) {
        return TransportStatusAdapter.toBannerButtonsStatusmoderate(transportStatus);
    }
}
