package ru.yandex.direct.core.entity.moderation.repository.receiving;

import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.moderation.model.TransportStatus;
import ru.yandex.direct.core.entity.moderation.repository.sending.TransportStatusAdapter;
import ru.yandex.direct.dbschema.ppc.enums.BannerLogosStatusmoderate;
import ru.yandex.direct.dbschema.ppc.tables.records.BannerLogosRecord;

import static ru.yandex.direct.dbschema.ppc.tables.BannerLogos.BANNER_LOGOS;
import static ru.yandex.direct.dbschema.ppc.tables.BannerLogosModerationVersions.BANNER_LOGOS_MODERATION_VERSIONS;

@Repository
public class BannerLogoModerationReceivingRepository extends ModerationReceivingRepositorySingleKey<BannerLogosRecord,
        BannerLogosStatusmoderate> {
    public BannerLogoModerationReceivingRepository() {
        super(BANNER_LOGOS.BID, BANNER_LOGOS_MODERATION_VERSIONS.VERSION,
                BANNER_LOGOS.STATUS_MODERATE);
    }

    @Override
    BannerLogosStatusmoderate transportStatusMap(TransportStatus transportStatus) {
        return TransportStatusAdapter.toBannerLogosStatusmoderate(transportStatus);
    }
}
