package ru.yandex.direct.core.entity.moderation.repository.receiving

import org.springframework.stereotype.Repository
import ru.yandex.direct.core.entity.moderation.model.TransportStatus
import ru.yandex.direct.core.entity.moderation.repository.sending.TransportStatusAdapter
import ru.yandex.direct.dbschema.ppc.enums.BannerMulticardSetsStatusmoderate
import ru.yandex.direct.dbschema.ppc.tables.BannerMulticardSets.BANNER_MULTICARD_SETS
import ru.yandex.direct.dbschema.ppc.tables.BannerMulticardSetsModerationVersions.BANNER_MULTICARD_SETS_MODERATION_VERSIONS
import ru.yandex.direct.dbschema.ppc.tables.records.BannerMulticardSetsRecord


@Repository
class BannerMulticardModerationReceivingRepository :
    ModerationReceivingRepositorySingleKey<BannerMulticardSetsRecord, BannerMulticardSetsStatusmoderate>(
        BANNER_MULTICARD_SETS.BID,
        BANNER_MULTICARD_SETS_MODERATION_VERSIONS.VERSION,
        BANNER_MULTICARD_SETS.STATUS_MODERATE,
    ) {

    override fun transportStatusMap(transportStatus: TransportStatus): BannerMulticardSetsStatusmoderate {
        return TransportStatusAdapter.toBannerMulticardSetsStatusModerate(transportStatus)
    }
}
