package ru.yandex.direct.core.entity.moderation.repository.receiving;

import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.moderation.model.TransportStatus;
import ru.yandex.direct.core.entity.moderation.repository.sending.TransportStatusAdapter;
import ru.yandex.direct.dbschema.ppc.enums.BannersStatusmoderate;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersRecord;

import static ru.yandex.direct.dbschema.ppc.tables.BannerModerationVersions.BANNER_MODERATION_VERSIONS;
import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;

@Repository
public class BannersModerationReceivingRepository extends ModerationReceivingRepositorySingleKey<BannersRecord,
        BannersStatusmoderate> {
    public BannersModerationReceivingRepository() {
        super(BANNERS.BID, BANNER_MODERATION_VERSIONS.VERSION, BANNERS.STATUS_MODERATE);
    }

    @Override
    BannersStatusmoderate transportStatusMap(TransportStatus transportStatus) {
        return TransportStatusAdapter.toBannerStatusModerate(transportStatus);
    }

}
