package ru.yandex.direct.core.entity.moderation.repository.receiving;

import java.util.Collection;
import java.util.List;

import org.jooq.Condition;
import org.jooq.Configuration;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.moderation.model.TransportStatus;
import ru.yandex.direct.core.entity.moderation.repository.sending.TransportStatusAdapter;
import ru.yandex.direct.core.entity.moderation.service.receiving.BaseModerationReceivingService;
import ru.yandex.direct.dbschema.ppc.enums.AdditionsItemCalloutsStatusmoderate;
import ru.yandex.direct.dbschema.ppc.tables.records.AdditionsItemCalloutsRecord;

import static ru.yandex.direct.dbschema.ppc.tables.AdditionsItemCallouts.ADDITIONS_ITEM_CALLOUTS;
import static ru.yandex.direct.dbschema.ppc.tables.CalloutModerationVersions.CALLOUT_MODERATION_VERSIONS;

@Repository
public class CalloutModerationReceivingRepository
        extends ModerationReceivingRepositorySingleKey<AdditionsItemCalloutsRecord, AdditionsItemCalloutsStatusmoderate> {

    public CalloutModerationReceivingRepository() {
        super(ADDITIONS_ITEM_CALLOUTS.ADDITIONS_ITEM_ID, CALLOUT_MODERATION_VERSIONS.VERSION,
                ADDITIONS_ITEM_CALLOUTS.STATUS_MODERATE);
    }

    @Override
    public List<Long> selectByKeysAndExportVersionsWithLock(
            Configuration configuration,
            Collection<BaseModerationReceivingService.ModeratedObjectKeyWithVersion<Long>> objectIdWithVersion) {
        Condition condition = makeConditionForObjects(objectIdWithVersion);

        return configuration.dsl()
                .select(ADDITIONS_ITEM_CALLOUTS.ADDITIONS_ITEM_ID)
                .from(ADDITIONS_ITEM_CALLOUTS)
                .leftJoin(CALLOUT_MODERATION_VERSIONS)
                .on(ADDITIONS_ITEM_CALLOUTS.ADDITIONS_ITEM_ID.eq(CALLOUT_MODERATION_VERSIONS.CALLOUT_ID))
                .where(condition)
                .forUpdate()
                .fetch(ADDITIONS_ITEM_CALLOUTS.ADDITIONS_ITEM_ID);
    }

    @Override
    AdditionsItemCalloutsStatusmoderate transportStatusMap(TransportStatus transportStatus) {
        return TransportStatusAdapter.toAdditionsItemCalloutsStatusmoderate(transportStatus);
    }
}
