package ru.yandex.direct.core.entity.moderation.repository.receiving;

import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.moderation.model.TransportStatus;
import ru.yandex.direct.core.entity.moderation.repository.sending.TransportStatusAdapter;
import ru.yandex.direct.dbschema.ppc.enums.BannerDisplayHrefsStatusmoderate;
import ru.yandex.direct.dbschema.ppc.tables.records.BannerDisplayHrefsRecord;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_DISPLAY_HREFS;
import static ru.yandex.direct.dbschema.ppc.tables.BannerDisplayhrefsModerationVersions.BANNER_DISPLAYHREFS_MODERATION_VERSIONS;

@Repository
public class DisplayHrefsModerationReceivingRepository extends ModerationReceivingRepositorySingleKey<BannerDisplayHrefsRecord,
        BannerDisplayHrefsStatusmoderate> {
    public DisplayHrefsModerationReceivingRepository() {
        super(BANNER_DISPLAY_HREFS.BID, BANNER_DISPLAYHREFS_MODERATION_VERSIONS.VERSION,
                BANNER_DISPLAY_HREFS.STATUS_MODERATE);
    }

    @Override
    BannerDisplayHrefsStatusmoderate transportStatusMap(TransportStatus transportStatus) {
        return TransportStatusAdapter.toBannerDisplayHrefsStatusmoderate(transportStatus);
    }
}
