package ru.yandex.direct.core.entity.moderation.repository.receiving;

import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.moderation.model.TransportStatus;
import ru.yandex.direct.core.entity.moderation.repository.sending.TransportStatusAdapter;
import ru.yandex.direct.dbschema.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.direct.dbschema.ppc.tables.records.BannerImagesRecord;

import static ru.yandex.direct.dbschema.ppc.tables.BannerImages.BANNER_IMAGES;
import static ru.yandex.direct.dbschema.ppc.tables.BannerImagesModerationVersions.BANNER_IMAGES_MODERATION_VERSIONS;

@Repository
public class ImageModerationReceivingRepository extends ModerationReceivingRepositorySingleKey<BannerImagesRecord,
        BannerImagesStatusmoderate> {
    public ImageModerationReceivingRepository() {
        super(BANNER_IMAGES.BID, BANNER_IMAGES_MODERATION_VERSIONS.VERSION,
                BANNER_IMAGES.STATUS_MODERATE);
    }

    @Override
    BannerImagesStatusmoderate transportStatusMap(TransportStatus transportStatus) {
        return TransportStatusAdapter.toBannerImagesStatusmoderate(transportStatus);
    }
}
