package ru.yandex.direct.core.entity.moderation.repository.receiving;

import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.moderation.model.TransportStatus;
import ru.yandex.direct.core.entity.moderation.repository.sending.TransportStatusAdapter;
import ru.yandex.direct.dbschema.ppc.enums.MobileContentStatusiconmoderate;
import ru.yandex.direct.dbschema.ppc.tables.records.MobileContentRecord;

import static ru.yandex.direct.dbschema.ppc.tables.MobileContent.MOBILE_CONTENT;
import static ru.yandex.direct.dbschema.ppc.tables.MobileContentIconModerationVersions.MOBILE_CONTENT_ICON_MODERATION_VERSIONS;

@Repository
public class MobileContentIconModerationReceivingRepository
        extends ModerationReceivingRepositorySingleKey<MobileContentRecord, MobileContentStatusiconmoderate> {
    public MobileContentIconModerationReceivingRepository() {
        super(MOBILE_CONTENT.MOBILE_CONTENT_ID, MOBILE_CONTENT_ICON_MODERATION_VERSIONS.VERSION,
                MOBILE_CONTENT.STATUS_ICON_MODERATE);
    }

    @Override
    MobileContentStatusiconmoderate transportStatusMap(TransportStatus transportStatus) {
        return TransportStatusAdapter.toMobileContentStatusiconmoderate(transportStatus);
    }
}
