package ru.yandex.direct.core.entity.moderation.repository.receiving;

import org.jooq.Condition;
import org.jooq.Record;
import org.jooq.TableField;

import ru.yandex.direct.core.entity.moderation.service.receiving.BaseModerationReceivingService;

public abstract class ModerationReceivingRepositorySingleKey<H extends Record, T extends Enum<T>>
    extends ModerationReceivingRepository<H, T, Long> {

    protected ModerationReceivingRepositorySingleKey(TableField<H, Long> keyField, TableField<?, Long> versionField,
                                                     TableField<H, T> statusModerateField) {
        super(keyField, versionField, statusModerateField);
    }

    @Override
    protected Condition getWhereConditionForObject(BaseModerationReceivingService.ModeratedObjectKeyWithVersion<Long> objectKeyWithVersion) {
        return getKeyFields().get(0).eq(objectKeyWithVersion.getKey());
    }

    @Override
    protected Long mapRecordToKey(Record record) {
        return record.get(getKeyFields().get(0));
    }

}
