package ru.yandex.direct.core.entity.moderation.repository.receiving

import org.springframework.stereotype.Repository
import ru.yandex.direct.core.entity.moderation.model.TransportStatus
import ru.yandex.direct.core.entity.moderation.repository.sending.TransportStatusAdapter
import ru.yandex.direct.dbschema.ppc.enums.PromoactionsStatusmoderate
import ru.yandex.direct.dbschema.ppc.tables.Promoactions
import ru.yandex.direct.dbschema.ppc.tables.records.PromoactionsRecord

@Repository
class PromoExtensionModerationReceivingRepository
    : ModerationReceivingRepositorySingleKey<PromoactionsRecord, PromoactionsStatusmoderate>(
        Promoactions.PROMOACTIONS.ID,
        Promoactions.PROMOACTIONS.MOD_VERSION,
        Promoactions.PROMOACTIONS.STATUS_MODERATE,
    ) {

    override fun transportStatusMap(transportStatus: TransportStatus): PromoactionsStatusmoderate {
        return TransportStatusAdapter.toPromoactionStatusModerate(transportStatus)
    }
}
