package ru.yandex.direct.core.entity.moderation.repository.receiving;

import java.util.Collection;

import org.jooq.Condition;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.moderation.model.TransportStatus;
import ru.yandex.direct.core.entity.moderation.repository.sending.TransportStatusAdapter;
import ru.yandex.direct.core.entity.moderation.service.receiving.BaseModerationReceivingService;
import ru.yandex.direct.dbschema.ppc.enums.BannersStatussitelinksmoderate;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersRecord;

import static ru.yandex.direct.dbschema.ppc.tables.BannerSitelinksModerationVersions.BANNER_SITELINKS_MODERATION_VERSIONS;
import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;

@Repository
public class SitelinksModerationReceivingRepository extends ModerationReceivingRepositorySingleKey<BannersRecord,
        BannersStatussitelinksmoderate> {
    public SitelinksModerationReceivingRepository() {
        super(BANNERS.BID, BANNER_SITELINKS_MODERATION_VERSIONS.VERSION, BANNERS.STATUS_SITELINKS_MODERATE);
    }

    @Override
    BannersStatussitelinksmoderate transportStatusMap(TransportStatus transportStatus) {
        return TransportStatusAdapter.toBannersStatussitelinksmoderate(transportStatus);
    }

    @Override
    Condition makeConditionForObjects(Collection<BaseModerationReceivingService.ModeratedObjectKeyWithVersion<Long>> keysAndVersions) {
        return DSL.and(BANNERS.SITELINKS_SET_ID.isNotNull(), super.makeConditionForObjects(keysAndVersions));

    }

}
