package ru.yandex.direct.core.entity.moderation.repository.receiving;

import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.moderation.model.TransportStatus;
import ru.yandex.direct.core.entity.moderation.repository.sending.TransportStatusAdapter;
import ru.yandex.direct.dbschema.ppc.enums.BannerTurbolandingsStatusmoderate;
import ru.yandex.direct.dbschema.ppc.tables.records.BannerTurbolandingsRecord;

import static ru.yandex.direct.dbschema.ppc.tables.BannerTurboModerationVersions.BANNER_TURBO_MODERATION_VERSIONS;
import static ru.yandex.direct.dbschema.ppc.tables.BannerTurbolandings.BANNER_TURBOLANDINGS;

@Repository
public class TurboModerationReceivingRepository extends ModerationReceivingRepositorySingleKey<BannerTurbolandingsRecord,
        BannerTurbolandingsStatusmoderate> {
    public TurboModerationReceivingRepository() {
        super(BANNER_TURBOLANDINGS.BID, BANNER_TURBO_MODERATION_VERSIONS.VERSION, BANNER_TURBOLANDINGS.STATUS_MODERATE);
    }

    @Override
    BannerTurbolandingsStatusmoderate transportStatusMap(TransportStatus transportStatus) {
        return TransportStatusAdapter.toBannerTurbolandingsStatusmoderate(transportStatus);
    }
}
