package ru.yandex.direct.core.entity.moderation.repository.receiving;

import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.moderation.model.TransportStatus;
import ru.yandex.direct.core.entity.moderation.repository.sending.TransportStatusAdapter;
import ru.yandex.direct.dbschema.ppc.enums.BannersPhoneflag;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersRecord;

import static ru.yandex.direct.dbschema.ppc.tables.BannerVcardsModerationVersions.BANNER_VCARDS_MODERATION_VERSIONS;
import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;

@Repository
public class VcardModerationReceivingRepository extends ModerationReceivingRepositorySingleKey<BannersRecord, BannersPhoneflag> {

    public VcardModerationReceivingRepository() {
        super(BANNERS.BID, BANNER_VCARDS_MODERATION_VERSIONS.VERSION,
                BANNERS.PHONEFLAG);
    }

    @Override
    BannersPhoneflag transportStatusMap(TransportStatus transportStatus) {
        return TransportStatusAdapter.toBannersPhoneflag(transportStatus);
    }
}
