package ru.yandex.direct.core.entity.moderation.repository.receiving;

import java.util.List;

import org.apache.commons.lang3.tuple.Pair;
import org.jooq.Condition;
import org.jooq.Record;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.moderation.model.TransportStatus;
import ru.yandex.direct.core.entity.moderation.repository.sending.TransportStatusAdapter;
import ru.yandex.direct.core.entity.moderation.service.receiving.BaseModerationReceivingService;
import ru.yandex.direct.dbschema.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.direct.dbschema.ppc.tables.records.BannersPerformanceRecord;

import static ru.yandex.direct.dbschema.ppc.tables.BannerCreativesModerationVersions.BANNER_CREATIVES_MODERATION_VERSIONS;
import static ru.yandex.direct.dbschema.ppc.tables.BannersPerformance.BANNERS_PERFORMANCE;

@Repository
public class VideoAdditionModerationReceivingRepository
        extends ModerationReceivingRepository<BannersPerformanceRecord, BannersPerformanceStatusmoderate,
        Pair<Long, Long>> {

    public VideoAdditionModerationReceivingRepository() {
        super(List.of(BANNERS_PERFORMANCE.BID, BANNERS_PERFORMANCE.CREATIVE_ID),
                BANNER_CREATIVES_MODERATION_VERSIONS.VERSION,
                BANNERS_PERFORMANCE.STATUS_MODERATE);
    }

    @Override
    BannersPerformanceStatusmoderate transportStatusMap(TransportStatus transportStatus) {
        return TransportStatusAdapter.toBannersPerformanceStatusmoderate(transportStatus);
    }

    @Override
    protected Condition getWhereConditionForObject(BaseModerationReceivingService.ModeratedObjectKeyWithVersion<Pair<Long, Long>> objectKeyWithVersion) {
        return getKeyFields().get(0).eq(objectKeyWithVersion.getKey().getLeft())
                .and(getKeyFields().get(1).eq(objectKeyWithVersion.getKey().getRight()));
    }

    @Override
    protected Pair<Long, Long> mapRecordToKey(Record record) {
        return Pair.of(record.get(getKeyFields().get(0)), record.get(getKeyFields().get(1)));
    }
}
