package ru.yandex.direct.core.entity.moderation.repository.sending;

import java.util.Collection;
import java.util.List;

import org.jooq.Configuration;
import org.jooq.TableField;
import org.jooq.impl.DSL;

import ru.yandex.direct.common.jooqmapper.OldJooqMapperWithSupplier;
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupMappings;
import ru.yandex.direct.core.entity.banner.model.BannerWithAdImageModerationInfo;
import ru.yandex.direct.core.entity.banner.model.BannerWithModerationInfo;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.dbschema.ppc.enums.BannerImagesFormatsAvatarsHost;
import ru.yandex.direct.dbschema.ppc.enums.BannerImagesFormatsNamespace;

import static ru.yandex.direct.common.jooqmapper.FieldMapperFactory.convertibleField;
import static ru.yandex.direct.common.jooqmapper.FieldMapperFactory.field;
import static ru.yandex.direct.dbschema.ppc.Tables.ADGROUPS_MOBILE_CONTENT;
import static ru.yandex.direct.dbschema.ppc.Tables.AUTO_MODERATE;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_IMAGES_FORMATS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_MODERATION_VERSIONS;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.dbschema.ppc.Tables.CLIENTS;
import static ru.yandex.direct.dbschema.ppc.Tables.CLIENTS_OPTIONS;
import static ru.yandex.direct.dbschema.ppc.Tables.IMAGES;
import static ru.yandex.direct.dbschema.ppc.Tables.MOBILE_CONTENT;
import static ru.yandex.direct.dbschema.ppc.Tables.PHRASES;
import static ru.yandex.direct.dbschema.ppc.Tables.PRE_MODERATE_BANNERS;
import static ru.yandex.direct.dbschema.ppc.Tables.USERS;
import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;

public abstract class AbstractAdImageBannerModerationRepository extends BannersModerationRepository<BannerWithAdImageModerationInfo> {
    private final Collection<TableField<?, ?>> adImageBannerFields;
    private final OldJooqMapperWithSupplier<BannerWithAdImageModerationInfo> adImageBannerMapper;

    public AbstractAdImageBannerModerationRepository(ModerationOperationModeProvider moderationOperationModeProvider) {
        super(moderationOperationModeProvider);
        adImageBannerMapper = createAdImageBannerMapper();
        adImageBannerFields = adImageBannerMapper.getFieldsToRead();
    }

    @Override
    public List<BannerWithAdImageModerationInfo> loadObjectForModeration(Collection<Long> lockedKeys,
                                                                         Configuration configuration) {
        return DSL.using(configuration)
                .select(adImageBannerFields)
                .from(BANNERS)
                .join(PHRASES).on(PHRASES.PID.eq(BANNERS.PID))
                .join(CAMPAIGNS).on(CAMPAIGNS.CID.eq(BANNERS.CID))
                .join(USERS).on(USERS.UID.eq(CAMPAIGNS.UID))
                .join(CLIENTS).on(CLIENTS.CLIENT_ID.eq(CAMPAIGNS.CLIENT_ID))
                .join(IMAGES).on(IMAGES.BID.eq(BANNERS.BID))
                .join(BANNER_IMAGES_FORMATS).on(IMAGES.IMAGE_HASH.eq(BANNER_IMAGES_FORMATS.IMAGE_HASH))
                .leftJoin(AUTO_MODERATE).on(BANNERS.BID.eq(AUTO_MODERATE.BID))
                .leftJoin(PRE_MODERATE_BANNERS).on(BANNERS.BID.eq(PRE_MODERATE_BANNERS.BID))
                .leftJoin(BANNER_MODERATION_VERSIONS).on(BANNER_MODERATION_VERSIONS.BID.eq(BANNERS.BID))
                .leftJoin(CLIENTS_OPTIONS).on(CLIENTS_OPTIONS.CLIENT_ID.eq(CAMPAIGNS.CLIENT_ID))
                .leftJoin(ADGROUPS_MOBILE_CONTENT).on(ADGROUPS_MOBILE_CONTENT.PID.eq(BANNERS.PID))
                .leftJoin(MOBILE_CONTENT).on(MOBILE_CONTENT.MOBILE_CONTENT_ID.eq(ADGROUPS_MOBILE_CONTENT.MOBILE_CONTENT_ID))
                .where(BANNERS.BID.in(lockedKeys))
                .fetch(rec -> adImageBannerMapper.fromDb(new BannerWithAdImageModerationInfo(), rec));
    }


    private OldJooqMapperWithSupplier<BannerWithAdImageModerationInfo> createAdImageBannerMapper() {
        return ModerationRepositoryMapperProvider.createCommonMapperBuilder(BannerWithAdImageModerationInfo::new)
                .map(field(BANNERS.TITLE, BannerWithAdImageModerationInfo.TITLE))
                .map(field(BANNERS.BANNER_ID, BannerWithAdImageModerationInfo.BS_BANNER_ID))
                .map(field(BANNERS.TITLE_EXTENSION, BannerWithAdImageModerationInfo.TITLE_EXTENSION))
                .map(field(BANNERS.BODY, BannerWithAdImageModerationInfo.BODY))
                .map(field(BANNER_MODERATION_VERSIONS.VERSION, BannerWithAdImageModerationInfo.VERSION))
                .map(field(IMAGES.IMAGE_HASH, BannerWithAdImageModerationInfo.IMAGE_HASH))
                .map(convertibleField(CAMPAIGNS.TYPE, BannerWithAdImageModerationInfo.CAMPAIGN_TYPE)
                        .convertFromDbBy(CampaignType::fromSource))
                .map(convertibleField(BANNER_IMAGES_FORMATS.AVATARS_HOST, BannerWithAdImageModerationInfo.HOST)
                        .convertFromDbBy(BannerImagesFormatsAvatarsHost::getLiteral))
                .map(field(BANNER_IMAGES_FORMATS.MDS_GROUP_ID, BannerWithAdImageModerationInfo.MDS_GROUP_ID))
                .map(convertibleField(BANNER_IMAGES_FORMATS.NAMESPACE, BannerWithAdImageModerationInfo.NAMESPACE)
                        .convertFromDbBy(BannerImagesFormatsNamespace::getLiteral))
                .map(convertibleField(PHRASES.GEO, BannerWithAdImageModerationInfo.GEO)
                        .convertToDbBy(AdGroupMappings::geoToDb)
                        .convertFromDbBy(AdGroupMappings::geoFromDb))
                .map(convertibleField(BANNERS.STATUS_MODERATE, BannerWithAdImageModerationInfo.TRANSPORT_STATUS)
                        .convertToDbBy(TransportStatusAdapter::toBannerStatusModerate)
                        .convertFromDbBy(TransportStatusAdapter::fromDb)
                )
                .map(field(MOBILE_CONTENT.BUNDLE_ID, BannerWithModerationInfo.BUNDLE_ID))
                .map(field(MOBILE_CONTENT.STORE_CONTENT_ID, BannerWithModerationInfo.STORE_CONTENT_ID))
                .map(field(MOBILE_CONTENT.MOBILE_CONTENT_ID, BannerWithModerationInfo.MOBILE_CONTENT_ID))
                .map(field(ADGROUPS_MOBILE_CONTENT.STORE_CONTENT_HREF, BannerWithModerationInfo.APP_HREF))
                .build();
    }
}
