package ru.yandex.direct.core.entity.moderation.repository.sending;

import java.time.LocalDateTime;
import java.util.function.Function;

import org.jooq.Record;
import org.jooq.Table;
import org.jooq.TableField;

import ru.yandex.direct.core.entity.moderation.model.TransportStatus;

import static com.google.common.base.Preconditions.checkNotNull;

public class AssetModerationRepositoryParams<T extends Record, S, V extends Record> {

    private final Table<T> table;
    private final TableField<T, Long> idField;
    private final TableField<T, S> statusModerateField;
    private final Function<TransportStatus, S> transportStatusConverter;

    private final Table<V> versionsTable;
    private final TableField<V, Long> versionsTableIdField;
    private final TableField<V, Long> versionField;
    private final TableField<V, LocalDateTime> createTimeField;

    public AssetModerationRepositoryParams(Table<T> table,
                                           TableField<T, Long> idField,
                                           TableField<T, S> statusModerateField,
                                           Function<TransportStatus, S> transportStatusConverter,
                                           Table<V> versionsTable,
                                           TableField<V, Long> versionsTableIdField,
                                           TableField<V, Long> versionField,
                                           TableField<V, LocalDateTime> createTimeField) {
        this.table = table;
        this.idField = idField;
        this.statusModerateField = statusModerateField;
        this.transportStatusConverter = transportStatusConverter;
        this.versionsTable = versionsTable;
        this.versionsTableIdField = versionsTableIdField;
        this.versionField = versionField;
        this.createTimeField = createTimeField;
    }

    public static AssetModerationRepositoryParamsStep0 builder() {
        return new AssetModerationRepositoryParamsStep0();
    }

    public Table<T> getTable() {
        return table;
    }

    public TableField<T, Long> getIdField() {
        return idField;
    }

    public TableField<T, S> getStatusModerateField() {
        return statusModerateField;
    }

    public Function<TransportStatus, S> getTransportStatusConverter() {
        return transportStatusConverter;
    }

    public Table<V> getVersionsTable() {
        return versionsTable;
    }

    public TableField<V, Long> getVersionField() {
        return versionField;
    }

    public TableField<V, LocalDateTime> getCreateTimeField() {
        return createTimeField;
    }

    public TableField<V, Long> getVersionsTableIdField() {
        return versionsTableIdField;
    }

    public static class AssetModerationRepositoryParamsStep0 {
        public <T extends Record> AssetModerationRepositoryParamsStep1<T> withTable(Table<T> table) {
            checkNotNull(table, "table");
            return new AssetModerationRepositoryParamsStep1<>(table);
        }
    }

    public static class AssetModerationRepositoryParamsStep1<T extends Record> {
        private Table<T> table;
        private TableField<T, Long> idField;

        public AssetModerationRepositoryParamsStep1(Table<T> table) {
            this.table = table;
        }

        public AssetModerationRepositoryParamsStep1<T> withIdField(TableField<T, Long> idField) {
            this.idField = idField;
            return this;
        }

        public <S> AssetModerationRepositoryParamsStep2<T, S> withStatusModerateField(
                TableField<T, S> statusModerateField) {
            checkNotNull(idField, "idField");
            checkNotNull(statusModerateField, "statusModerateField");
            return new AssetModerationRepositoryParamsStep2<>(table, idField, statusModerateField);
        }
    }

    public static class AssetModerationRepositoryParamsStep2<T extends Record, S> {
        private Table<T> table;
        private TableField<T, Long> idField;
        private TableField<T, S> statusModerateField;
        private Function<TransportStatus, S> transportStatusConverter;

        public AssetModerationRepositoryParamsStep2(Table<T> table, TableField<T, Long> idField,
                                                    TableField<T, S> statusModerateField) {

            this.table = table;
            this.idField = idField;
            this.statusModerateField = statusModerateField;
        }

        public AssetModerationRepositoryParamsStep2<T, S> withTransportStatusConverter(
                Function<TransportStatus, S> transportStatusConverter) {
            this.transportStatusConverter = transportStatusConverter;
            return this;
        }

        public <V extends Record> AssetModerationRepositoryParamsStep3<T, S, V> withVersionsTable(
                Table<V> versionsTable) {
            checkNotNull(transportStatusConverter, "transportStatusConverter");
            checkNotNull(versionsTable, "versionsTable");
            return new AssetModerationRepositoryParamsStep3<>(table, idField, statusModerateField,
                    transportStatusConverter, versionsTable);
        }
    }

    public static class AssetModerationRepositoryParamsStep3<T extends Record, S, V extends Record> {
        private Table<T> table;
        private TableField<T, Long> idField;
        private TableField<T, S> statusModerateField;
        private Function<TransportStatus, S> transportStatusConverter;

        private Table<V> versionsTable;
        private TableField<V, Long> versionsTableIdField;
        private TableField<V, Long> versionField;
        private TableField<V, LocalDateTime> createTimeField;

        public AssetModerationRepositoryParamsStep3(Table<T> table, TableField<T, Long> idField,
                                                    TableField<T, S> statusModerateField,
                                                    Function<TransportStatus, S> transportStatusConverter,
                                                    Table<V> versionsTable) {
            this.table = table;
            this.idField = idField;
            this.statusModerateField = statusModerateField;
            this.transportStatusConverter = transportStatusConverter;
            this.versionsTable = versionsTable;
        }

        public AssetModerationRepositoryParamsStep3<T, S, V> withVersionsTableIdField(
                TableField<V, Long> versionsTableIdField) {
            this.versionsTableIdField = versionsTableIdField;
            return this;
        }

        public AssetModerationRepositoryParamsStep3<T, S, V> withVersionField(TableField<V, Long> versionField) {
            this.versionField = versionField;
            return this;
        }

        public AssetModerationRepositoryParamsStep3<T, S, V> withCreateTimeField(
                TableField<V, LocalDateTime> createTimeField) {
            this.createTimeField = createTimeField;
            return this;
        }

        public AssetModerationRepositoryParams<T, S, V> build() {
            checkNotNull(versionField, "versionField");
            checkNotNull(versionsTableIdField, "versionsTableIdField");
            checkNotNull(createTimeField, "createTimeField");

            return new AssetModerationRepositoryParams<>(
                    table,
                    idField,
                    statusModerateField,
                    transportStatusConverter,
                    versionsTable,
                    versionsTableIdField,
                    versionField,
                    createTimeField);
        }
    }
}
