package ru.yandex.direct.core.entity.moderation.repository.sending;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS_CPM_PRICE;
import static ru.yandex.direct.dbschema.ppcdict.tables.CpmPricePackages.CPM_PRICE_PACKAGES;
import static ru.yandex.direct.dbschema.ppcdict.tables.Products.PRODUCTS;

@Repository
public class BusinessUnitModerationRepository {

    private final DslContextProvider dslContextProvider;

    @Autowired
    public BusinessUnitModerationRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    public Map<Long, Long> getBidsToBusinessUnits(int shard, Collection<Long> bids) {

        Map<Long, Long> bidToPackage = dslContextProvider.ppc(shard).select(BANNERS.BID, CAMPAIGNS_CPM_PRICE.PACKAGE_ID)
                .from(BANNERS)
                .join(CAMPAIGNS_CPM_PRICE).using(BANNERS.CID)
                .where(BANNERS.BID.in(bids))
                .fetchMap(BANNERS.BID, CAMPAIGNS_CPM_PRICE.PACKAGE_ID);

        var packageToBusinessUnit = dslContextProvider.ppcdict().select(CPM_PRICE_PACKAGES.PACKAGE_ID,
                PRODUCTS.BUSINESS_UNIT)
                .from(CPM_PRICE_PACKAGES)
                .join(PRODUCTS).using(CPM_PRICE_PACKAGES.PRODUCT_ID)
                .where(CPM_PRICE_PACKAGES.PACKAGE_ID.in(bidToPackage.values()),
                        PRODUCTS.BUSINESS_UNIT.isNotNull()
                )
                .fetchMap(CPM_PRICE_PACKAGES.PACKAGE_ID, PRODUCTS.BUSINESS_UNIT);

        return bids.stream()
                .filter(bidToPackage::containsKey)
                .filter(e -> packageToBusinessUnit.containsKey(bidToPackage.get(e)))
                .collect(Collectors.toMap(e -> e, x -> packageToBusinessUnit.get(bidToPackage.get(x))));
    }

}
