package ru.yandex.direct.core.entity.moderation.repository.sending;

import java.util.Collection;
import java.util.List;

import org.jooq.Configuration;
import org.jooq.TableField;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.common.jooqmapper.OldJooqMapperWithSupplier;
import ru.yandex.direct.core.entity.banner.model.BannerWithModerationInfo;
import ru.yandex.direct.core.entity.contentpromotion.model.ContentPromotionContentType;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;
import ru.yandex.direct.dbschema.ppc.enums.PhrasesAdgroupType;

import static ru.yandex.direct.common.jooqmapper.FieldMapperFactory.convertibleField;
import static ru.yandex.direct.common.jooqmapper.FieldMapperFactory.field;
import static ru.yandex.direct.dbschema.ppc.Tables.AUTO_MODERATE;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_CONTENT_PROMOTION;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_MODERATION_VERSIONS;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.dbschema.ppc.Tables.CLIENTS;
import static ru.yandex.direct.dbschema.ppc.Tables.CLIENTS_OPTIONS;
import static ru.yandex.direct.dbschema.ppc.Tables.CONTENT_PROMOTION;
import static ru.yandex.direct.dbschema.ppc.Tables.PHRASES;
import static ru.yandex.direct.dbschema.ppc.Tables.PRE_MODERATE_BANNERS;
import static ru.yandex.direct.dbschema.ppc.Tables.USERS;
import static ru.yandex.direct.dbschema.ppc.enums.BannersBannerType.content_promotion;
import static ru.yandex.direct.dbschema.ppc.enums.ContentPromotionType.eda;
import static ru.yandex.direct.dbschema.ppc.enums.ContentPromotionType.service;
import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;

@Repository
public class ContentPromotionBannerRepository extends BannersModerationRepository<BannerWithModerationInfo> {
    private final Collection<TableField<?, ?>> moderationContentPromotionRequestFields;
    private final OldJooqMapperWithSupplier<BannerWithModerationInfo> contentPromotionBannerMapper;

    @Autowired
    public ContentPromotionBannerRepository(ModerationOperationModeProvider moderationOperationModeProvider) {
        super(moderationOperationModeProvider);
        this.contentPromotionBannerMapper = createContentPromotionBannerMapper();
        this.moderationContentPromotionRequestFields = contentPromotionBannerMapper.getFieldsToRead();
    }

    @Override
    protected BannersBannerType getBannerType() {
        return content_promotion;
    }

    @Override
    protected List<PhrasesAdgroupType> getPhrasesAdgroupTypes() {
        return List.of(PhrasesAdgroupType.content_promotion);
    }

    @Override
    public List<BannerWithModerationInfo> loadObjectForModeration(Collection<Long> lockedKeys,
                                                                  Configuration configuration) {
        return DSL.using(configuration)
                .select(moderationContentPromotionRequestFields)
                .from(BANNERS)
                .join(PHRASES).on(PHRASES.PID.eq(BANNERS.PID))
                .join(CAMPAIGNS).on(CAMPAIGNS.CID.eq(BANNERS.CID))
                .join(USERS).on(USERS.UID.eq(CAMPAIGNS.UID))
                .join(CLIENTS).on(CLIENTS.CLIENT_ID.eq(CAMPAIGNS.CLIENT_ID))
                .leftJoin(CLIENTS_OPTIONS).on(CLIENTS_OPTIONS.CLIENT_ID.eq(CAMPAIGNS.CLIENT_ID))
                .join(BANNERS_CONTENT_PROMOTION).on(BANNERS.BID.eq(BANNERS_CONTENT_PROMOTION.BID))
                .join(CONTENT_PROMOTION).on(CONTENT_PROMOTION.ID.eq(BANNERS_CONTENT_PROMOTION.CONTENT_PROMOTION_ID))
                .leftJoin(AUTO_MODERATE).on(BANNERS.BID.eq(AUTO_MODERATE.BID))
                .leftJoin(PRE_MODERATE_BANNERS).on(BANNERS.BID.eq(PRE_MODERATE_BANNERS.BID))
                .leftJoin(BANNER_MODERATION_VERSIONS).on(BANNER_MODERATION_VERSIONS.BID.eq(BANNERS.BID))
                .where(BANNERS.BID.in(lockedKeys))
                .and(CONTENT_PROMOTION.TYPE.notIn(service, eda))
                .fetch(rec -> contentPromotionBannerMapper.fromDb(new BannerWithModerationInfo(), rec));
    }

    private OldJooqMapperWithSupplier<BannerWithModerationInfo> createContentPromotionBannerMapper() {
        return ModerationRepositoryMapperProvider.createCommonBannerMapperBuilder()
                .map(field(BANNERS.BANNER_ID, BannerWithModerationInfo.BS_BANNER_ID))
                .map(field(BANNER_MODERATION_VERSIONS.VERSION, BannerWithModerationInfo.VERSION))
                .map(field(USERS.LOGIN, BannerWithModerationInfo.LOGIN))

                .map(field(BANNERS.TITLE, BannerWithModerationInfo.TITLE))
                .map(field(BANNERS.BODY, BannerWithModerationInfo.BODY))
                .map(field(CONTENT_PROMOTION.ID, BannerWithModerationInfo.CONTENT_PROMOTION_ID))
                .map(field(CONTENT_PROMOTION.METADATA, BannerWithModerationInfo.CONTENT_PROMOTION_METADATA))
                .map(field(CONTENT_PROMOTION.PREVIEW_URL, BannerWithModerationInfo.CONTENT_PROMOTION_PREVIEW_URL))
                .map(convertibleField(CONTENT_PROMOTION.TYPE, BannerWithModerationInfo.CONTENT_PROMOTION_TYPE)
                        .convertToDbBy(ContentPromotionContentType::toSource)
                        .convertFromDbBy(ContentPromotionContentType::fromSource))
                .map(convertibleField(BANNERS.STATUS_MODERATE, BannerWithModerationInfo.TRANSPORT_STATUS)
                        .convertToDbBy(TransportStatusAdapter::toBannerStatusModerate)
                        .convertFromDbBy(TransportStatusAdapter::fromDb)
                )
                .map(field(BANNERS_CONTENT_PROMOTION.VISIT_URL, BannerWithModerationInfo.CONTENT_PROMOTION_VISIT_URL))
                .build();
    }
}
