package ru.yandex.direct.core.entity.moderation.repository.sending;

import java.util.Collection;
import java.util.List;

import org.jooq.Configuration;
import org.jooq.TableField;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.common.jooqmapper.OldJooqMapperWithSupplier;
import ru.yandex.direct.core.entity.banner.model.BannerWithModerationInfo;
import ru.yandex.direct.core.entity.creative.repository.CreativeMappings;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.dbschema.ppc.Tables;
import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;
import ru.yandex.direct.dbschema.ppc.enums.PhrasesAdgroupType;

import static ru.yandex.direct.common.jooqmapper.FieldMapperFactory.convertibleField;
import static ru.yandex.direct.common.jooqmapper.FieldMapperFactory.field;
import static ru.yandex.direct.dbschema.ppc.Tables.AUTO_MODERATE;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_PERFORMANCE;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_MODERATION_VERSIONS;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNER_PERMALINKS;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.dbschema.ppc.Tables.CLIENTS_OPTIONS;
import static ru.yandex.direct.dbschema.ppc.Tables.PERF_CREATIVES;
import static ru.yandex.direct.dbschema.ppc.Tables.PRE_MODERATE_BANNERS;
import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;

@Repository
public class CpmGeoPinBannersRepository extends BannersModerationRepository<BannerWithModerationInfo> {
    private final Collection<TableField<?, ?>> moderationRequestFields;
    private final OldJooqMapperWithSupplier<BannerWithModerationInfo> cpmGeoPinBannerMapper;

    @Autowired
    public CpmGeoPinBannersRepository(ModerationOperationModeProvider moderationOperationModeProvider) {
        super(moderationOperationModeProvider);
        this.cpmGeoPinBannerMapper = createCpmGeoPinBannerMapper();
        this.moderationRequestFields = cpmGeoPinBannerMapper.getFieldsToRead();
    }

    @Override
    protected BannersBannerType getBannerType() {
        return BannersBannerType.cpm_geo_pin;
    }

    @Override
    protected List<PhrasesAdgroupType> getPhrasesAdgroupTypes() {
        return List.of(PhrasesAdgroupType.cpm_geo_pin);
    }

    @Override
    public List<BannerWithModerationInfo> loadObjectForModeration(Collection<Long> lockedKeys,
                                                                  Configuration configuration) {
        return DSL.using(configuration)
                .select(moderationRequestFields)
                .from(BANNERS)
                .join(CAMPAIGNS).on(CAMPAIGNS.CID.eq(BANNERS.CID))
                .join(BANNER_PERMALINKS).on(BANNER_PERMALINKS.BID.eq(Tables.BANNERS.BID))
                .join(BANNERS_PERFORMANCE).on(BANNERS_PERFORMANCE.BID.eq(BANNERS.BID))
                .join(PERF_CREATIVES).on(PERF_CREATIVES.CREATIVE_ID.eq(BANNERS_PERFORMANCE.CREATIVE_ID))
                .leftJoin(AUTO_MODERATE).on(BANNERS.BID.eq(AUTO_MODERATE.BID))
                .leftJoin(PRE_MODERATE_BANNERS).on(BANNERS.BID.eq(PRE_MODERATE_BANNERS.BID))
                .leftJoin(BANNER_MODERATION_VERSIONS).on(BANNER_MODERATION_VERSIONS.BID.eq(BANNERS.BID))
                .leftJoin(CLIENTS_OPTIONS).on(CLIENTS_OPTIONS.CLIENT_ID.eq(CAMPAIGNS.CLIENT_ID))
                .where(BANNERS.BID.in(lockedKeys))
                .fetch(rec -> cpmGeoPinBannerMapper.fromDb(new BannerWithModerationInfo(), rec));
    }

    private OldJooqMapperWithSupplier<BannerWithModerationInfo> createCpmGeoPinBannerMapper() {
        return ModerationRepositoryMapperProvider.createCommonBannerMapperBuilder()
                .map(field(BANNER_MODERATION_VERSIONS.VERSION, BannerWithModerationInfo.VERSION))
                .map(field(BANNERS.BANNER_ID, BannerWithModerationInfo.BS_BANNER_ID))
                .map(field(PERF_CREATIVES.CREATIVE_ID, BannerWithModerationInfo.CREATIVE_ID))
                .map(field(PERF_CREATIVES.PREVIEW_URL, BannerWithModerationInfo.CREATIVE_PREVIEW_URL))
                .map(field(BANNER_PERMALINKS.PERMALINK, BannerWithModerationInfo.PERMALINK_ID))
                .map(convertibleField(PERF_CREATIVES.ADDITIONAL_DATA, BannerWithModerationInfo.ADDITIONAL_DATA)
                        .convertToDbBy(CreativeMappings::additionalDataToDb)
                        .convertFromDbBy(CreativeMappings::additionalDataFromDb))
                .map(convertibleField(PERF_CREATIVES.MODERATE_INFO, BannerWithModerationInfo.MODERATE_INFO)
                        .convertToDbBy(CreativeMappings::moderationInfoToDb)
                        .convertFromDbBy(CreativeMappings::moderationInfoFromDb))
                .map(convertibleField(BANNERS.STATUS_MODERATE, BannerWithModerationInfo.TRANSPORT_STATUS)
                        .convertToDbBy(TransportStatusAdapter::toBannerStatusModerate)
                        .convertFromDbBy(TransportStatusAdapter::fromDb)
                )
                .map(convertibleField(BANNERS.STATUS_MODERATE, BannerWithModerationInfo.TRANSPORT_STATUS)
                        .convertToDbBy(TransportStatusAdapter::toBannerStatusModerate)
                        .convertFromDbBy(TransportStatusAdapter::fromDb)
                )
                .build();
    }
}
