package ru.yandex.direct.core.entity.moderation.repository.sending;

import java.util.List;

import org.jooq.Record;
import org.jooq.SelectJoinStep;
import org.jooq.SelectOnConditionStep;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.common.jooqmapper.OldJooqMapperBuilder;
import ru.yandex.direct.core.entity.banner.model.BannerWithTextAndImageModerationInfo;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;
import ru.yandex.direct.dbschema.ppc.enums.PhrasesAdgroupType;

import static ru.yandex.direct.common.jooqmapper.FieldMapperFactory.field;
import static ru.yandex.direct.dbschema.ppc.Tables.ADGROUPS_DYNAMIC;
import static ru.yandex.direct.dbschema.ppc.Tables.DOMAINS;
import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;

@Repository
public class DynamicBannerModerationRepository extends TextBannerModerationRepository {
    @Autowired
    public DynamicBannerModerationRepository(ModerationOperationModeProvider moderationOperationModeProvider) {
        super(moderationOperationModeProvider);
    }

    @Override
    protected BannersBannerType getBannerType() {
        return BannersBannerType.dynamic;
    }

    @Override
    protected List<PhrasesAdgroupType> getPhrasesAdgroupTypes() {
        return List.of(PhrasesAdgroupType.dynamic, PhrasesAdgroupType.base);
    }

    @Override
    protected ModerationObjectType getModerationObjectType() {
        return ModerationObjectType.DYNAMIC;
    }

    @Override
    protected SelectOnConditionStep<Record> addJoins(SelectJoinStep<Record> joinStep) {
        return super.addJoins(joinStep)
                .leftJoin(ADGROUPS_DYNAMIC).on(ADGROUPS_DYNAMIC.PID.eq(BANNERS.PID))
                .leftJoin(DOMAINS).on(DOMAINS.DOMAIN_ID.eq(ADGROUPS_DYNAMIC.MAIN_DOMAIN_ID));
    }

    @Override
    protected OldJooqMapperBuilder<BannerWithTextAndImageModerationInfo> buildMapper(
            OldJooqMapperBuilder<BannerWithTextAndImageModerationInfo> mapperBuilder) {
        return super.buildMapper(mapperBuilder)
                .map(field(DOMAINS.DOMAIN, BannerWithTextAndImageModerationInfo.DOMAIN));
    }
}
