package ru.yandex.direct.core.entity.moderation.repository.sending;

import java.util.Collection;
import java.util.List;

import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.impl.DSL;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.banner.model.BannerWithModerationInfo;
import ru.yandex.direct.core.entity.banner.type.additionalhrefs.BannerAdditionalHrefsRepository;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.model.TransportStatus;
import ru.yandex.direct.dbschema.ppc.enums.PerfCreativesCreativeType;

import static ru.yandex.direct.core.entity.moderation.ModerationOperationMode.RESTRICTED;
import static ru.yandex.direct.core.entity.moderation.service.ModerationObjectType.HTML5;

@Repository
public abstract class Html5BannerModerationRepository extends BannerWithCreativesModerationRepository {

    protected Html5BannerModerationRepository(BannerAdditionalHrefsRepository bannerAdditionalHrefsRepository,
                                              ModerationOperationModeProvider moderationOperationModeProvider) {
        super(bannerAdditionalHrefsRepository, moderationOperationModeProvider);
    }

    @Override
    protected Condition getStatusModerateCondition() {
        // в ограниченном режиме не фильтруем по статусам модерации, подходят любые
        if (getModerationOperationModeProvider().getMode(HTML5).equals(RESTRICTED)) {
            return DSL.trueCondition();
        }
        return super.getStatusModerateCondition();
    }

    @Override
    public void updateStatusModerate(Configuration config, TransportStatus from, TransportStatus to,
                                     Collection<BannerWithModerationInfo> objects) {
        // в ограниченном режиме не обновляем статусы модерации
        if (getModerationOperationModeProvider().getMode(HTML5).equals(RESTRICTED)) {
            return;
        }
        super.updateStatusModerate(config, from, to, objects);
    }

    @Override
    protected List<PerfCreativesCreativeType> getCreativeTypes() {
        return List.of(PerfCreativesCreativeType.html5_creative);
    }
}
