package ru.yandex.direct.core.entity.moderation.repository.sending;

import java.util.List;

import org.jooq.Record;
import org.jooq.SelectJoinStep;
import org.jooq.SelectOnConditionStep;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.common.jooqmapper.OldJooqMapperBuilder;
import ru.yandex.direct.core.entity.banner.model.BannerWithTextAndImageModerationInfo;
import ru.yandex.direct.core.entity.moderation.ModerationOperationModeProvider;
import ru.yandex.direct.core.entity.moderation.service.ModerationObjectType;
import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;
import ru.yandex.direct.dbschema.ppc.enums.PhrasesAdgroupType;

import static ru.yandex.direct.common.jooqmapper.FieldMapperFactory.field;
import static ru.yandex.direct.dbschema.ppc.Tables.ADGROUPS_MOBILE_CONTENT;
import static ru.yandex.direct.dbschema.ppc.Tables.MOBILE_CONTENT;
import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;

@Repository
public class MobileContentBannerModerationRepository extends TextBannerModerationRepository {

    @Autowired
    public MobileContentBannerModerationRepository(ModerationOperationModeProvider moderationOperationModeProvider) {
        super(moderationOperationModeProvider);
    }

    @Override
    protected BannersBannerType getBannerType() {
        return BannersBannerType.mobile_content;
    }

    @Override
    protected List<PhrasesAdgroupType> getPhrasesAdgroupTypes() {
        return List.of(PhrasesAdgroupType.mobile_content);
    }

    @Override
    protected ModerationObjectType getModerationObjectType() {
        return ModerationObjectType.MOBILE_CONTENT;
    }

    @Override
    protected SelectOnConditionStep<Record> addJoins(SelectJoinStep<Record> joinStep) {
        return super.addJoins(joinStep)
                .leftJoin(ADGROUPS_MOBILE_CONTENT).on(ADGROUPS_MOBILE_CONTENT.PID.eq(BANNERS.PID))
                .leftJoin(MOBILE_CONTENT).on(MOBILE_CONTENT.MOBILE_CONTENT_ID.eq(ADGROUPS_MOBILE_CONTENT.MOBILE_CONTENT_ID));
    }

    @Override
    protected OldJooqMapperBuilder<BannerWithTextAndImageModerationInfo> buildMapper(OldJooqMapperBuilder<BannerWithTextAndImageModerationInfo> mapperBuilder) {
        return super.buildMapper(mapperBuilder)
                .map(field(MOBILE_CONTENT.BUNDLE_ID, BannerWithTextAndImageModerationInfo.BUNDLE_ID))
                .map(field(MOBILE_CONTENT.STORE_CONTENT_ID, BannerWithTextAndImageModerationInfo.STORE_CONTENT_ID))
                .map(field(MOBILE_CONTENT.MOBILE_CONTENT_ID, BannerWithTextAndImageModerationInfo.MOBILE_CONTENT_ID))
                .map(field(ADGROUPS_MOBILE_CONTENT.STORE_CONTENT_HREF, BannerWithTextAndImageModerationInfo.APP_HREF));
    }
}
