package ru.yandex.direct.core.entity.moderation.repository.sending;

import java.util.function.Supplier;

import ru.yandex.direct.common.jooqmapper.OldJooqMapperBuilder;
import ru.yandex.direct.core.entity.banner.model.BannerFlags;
import ru.yandex.direct.core.entity.banner.model.BannerStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithModerationInfo;
import ru.yandex.direct.core.entity.banner.model.ModerationableBanner;
import ru.yandex.direct.core.entity.moderation.repository.ModerationRepository;
import ru.yandex.direct.jooqmapper.read.JooqReaderWithSupplierBuilder;

import static java.util.function.Function.identity;
import static ru.yandex.direct.common.jooqmapper.FieldMapperFactory.convertibleField;
import static ru.yandex.direct.common.jooqmapper.FieldMapperFactory.field;
import static ru.yandex.direct.common.util.RepositoryUtils.setFromDb;
import static ru.yandex.direct.dbschema.ppc.Tables.AUTO_MODERATE;
import static ru.yandex.direct.dbschema.ppc.Tables.CAMPAIGNS;
import static ru.yandex.direct.dbschema.ppc.Tables.CLIENTS_OPTIONS;
import static ru.yandex.direct.dbschema.ppc.Tables.PRE_MODERATE_BANNERS;
import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;

/**
 * Jooq мапперы для {@link ModerationRepository}
 */
public class ModerationRepositoryMapperProvider {

    /**
     * Маппер для всех баннеров, отправляемых в модерацию.
     *
     * @see #createCommonBannerMapperBuilder
     */
    @Deprecated
    public static OldJooqMapperBuilder<BannerWithModerationInfo> createCommonBannerMapperBuilder() {
        return createCommonMapperBuilder(BannerWithModerationInfo::new);
    }

    /**
     * Маппер для запросов вердиктов, отправляемых в модерацию.
     *
     * @see #createCommonBannerMapperBuilder(Supplier)
     */
    @Deprecated
    public static OldJooqMapperBuilder<BannerWithModerationInfo> createCommonVerdictRequestMapperBuilder() {
        return createCommonMapperBuilder(BannerWithModerationInfo::new);
    }

    /**
     * устарел из-за OldJooqMapperBuilder, лучше использовать {@link #createCommonBannerMapperBuilder(Supplier)}
     */
    @Deprecated
    public static <T extends ModerationableBanner> OldJooqMapperBuilder<T> createCommonMapperBuilder(
            Supplier<T> bannerModelSupplier) {
        return new OldJooqMapperBuilder<>(bannerModelSupplier)
                .map(field(BANNERS.BID, ModerationableBanner.ID))
                .map(field(BANNERS.PID, ModerationableBanner.AD_GROUP_ID))
                .map(field(BANNERS.CID, ModerationableBanner.CAMPAIGN_ID))
                .map(field(BANNERS.DOMAIN, ModerationableBanner.DOMAIN))
                .map(field(BANNERS.HREF, ModerationableBanner.HREF))
                .map(field(BANNERS.BANNER_TYPE, ModerationableBanner.BANNER_TYPE))
                .map(convertibleField(BANNERS.STATUS_MODERATE, ModerationableBanner.STATUS_MODERATE)
                        .convertToDbBy(BannerStatusModerate::toSource)
                        .convertFromDbBy(BannerStatusModerate::fromSource)
                        .withDatabaseDefault())
                .map(convertibleField(BANNERS.FLAGS, ModerationableBanner.FLAGS)
                        .convertToDbBy(BannerFlags::toSource)
                        .convertFromDbBy(BannerFlags::fromSource)
                        .withDatabaseDefault())
                .map(field(CAMPAIGNS.CLIENT_ID, ModerationableBanner.CLIENT_ID))
                .map(field(CAMPAIGNS.UID, ModerationableBanner.UID))
                .map(field(PRE_MODERATE_BANNERS.BID, ModerationableBanner.BID_RE_MODERATE))
                .map(field(AUTO_MODERATE.BID, ModerationableBanner.BID_AUTO_MODERATE))
                .map(convertibleField(CLIENTS_OPTIONS.CLIENT_FLAGS, ModerationableBanner.CLIENT_FLAGS)
                        .convertFromDbBy(clientFlagsRaw -> setFromDb(clientFlagsRaw, identity())));
    }

    public static <T extends ModerationableBanner> JooqReaderWithSupplierBuilder<T> createCommonBannerMapperBuilder(
            Supplier<T> bannerModelSupplier) {
        return JooqReaderWithSupplierBuilder.builder(bannerModelSupplier)
                .readProperty(ModerationableBanner.ID, fromField(BANNERS.BID))
                .readProperty(ModerationableBanner.AD_GROUP_ID, fromField(BANNERS.PID))
                .readProperty(ModerationableBanner.CAMPAIGN_ID, fromField(BANNERS.CID))
                .readProperty(ModerationableBanner.DOMAIN, fromField(BANNERS.DOMAIN))
                .readProperty(ModerationableBanner.HREF, fromField(BANNERS.HREF))
                .readProperty(ModerationableBanner.BANNER_TYPE, fromField(BANNERS.BANNER_TYPE))
                .readProperty(ModerationableBanner.STATUS_MODERATE, fromField(BANNERS.STATUS_MODERATE)
                        .by(BannerStatusModerate::fromSource))
                .readProperty(ModerationableBanner.FLAGS, fromField(BANNERS.FLAGS)
                        .by(BannerFlags::fromSource))
                .readProperty(ModerationableBanner.CLIENT_ID, fromField(CAMPAIGNS.CLIENT_ID))
                .readProperty(ModerationableBanner.UID, fromField(CAMPAIGNS.UID))
                .readProperty(ModerationableBanner.BID_RE_MODERATE, fromField(PRE_MODERATE_BANNERS.BID))
                .readProperty(ModerationableBanner.BID_AUTO_MODERATE, fromField(AUTO_MODERATE.BID))
                .readProperty(ModerationableBanner.CLIENT_FLAGS, fromField(CLIENTS_OPTIONS.CLIENT_FLAGS)
                        .by(clientFlagsRaw -> setFromDb(clientFlagsRaw, identity())));
    }

}
