package ru.yandex.direct.core.entity.moderation.repository.sending;

import java.util.Collection;
import java.util.List;

import org.apache.commons.lang3.tuple.Pair;
import org.jooq.Configuration;

import ru.yandex.direct.core.entity.moderation.model.Moderationable;
import ru.yandex.direct.core.entity.moderation.model.TransportStatus;

public interface ModerationSendingRepository<D, E extends Moderationable> {
    long getReadyObjectsCount(Configuration configuration);

    Collection<D> lockKeys(Collection<D> keys, Configuration configuration);

    List<E> loadObjectForModeration(Collection<D> lockedKeys, Configuration configuration);

    void updateStatusModerate(Configuration config, TransportStatus from, TransportStatus to,
                              Collection<E> loadedObjects);

    void setModerationVersions(Configuration configuration, List<Pair<E, Long>> inserts);
}
