package ru.yandex.direct.core.entity.moderation.repository.sending;

import ru.yandex.direct.core.entity.moderation.model.TransportStatus;
import ru.yandex.direct.dbschema.ppc.enums.AdditionsItemCalloutsStatusmoderate;
import ru.yandex.direct.dbschema.ppc.enums.BannerButtonsStatusmoderate;
import ru.yandex.direct.dbschema.ppc.enums.BannerDisplayHrefsStatusmoderate;
import ru.yandex.direct.dbschema.ppc.enums.BannerImagesStatusmoderate;
import ru.yandex.direct.dbschema.ppc.enums.BannerLogosStatusmoderate;
import ru.yandex.direct.dbschema.ppc.enums.BannerMulticardSetsStatusmoderate;
import ru.yandex.direct.dbschema.ppc.enums.BannerTurbolandingsStatusmoderate;
import ru.yandex.direct.dbschema.ppc.enums.BannersPerformanceStatusmoderate;
import ru.yandex.direct.dbschema.ppc.enums.BannersPhoneflag;
import ru.yandex.direct.dbschema.ppc.enums.BannersStatusmoderate;
import ru.yandex.direct.dbschema.ppc.enums.BannersStatussitelinksmoderate;
import ru.yandex.direct.dbschema.ppc.enums.BidsStatusmoderate;
import ru.yandex.direct.dbschema.ppc.enums.CampaignsStatusmoderate;
import ru.yandex.direct.dbschema.ppc.enums.MobileContentStatusiconmoderate;
import ru.yandex.direct.dbschema.ppc.enums.ModerateBannerPagesStatusmoderate;
import ru.yandex.direct.dbschema.ppc.enums.PerfCreativesStatusmoderate;
import ru.yandex.direct.dbschema.ppc.enums.PhrasesStatusmoderate;
import ru.yandex.direct.dbschema.ppc.enums.PromoactionsStatusmoderate;

public class TransportStatusAdapter {
    private TransportStatusAdapter() {

    }

    public static <T> TransportStatus fromDb(T from) {
        return TransportStatus.valueOf(from.toString());
    }

    public static BannersStatusmoderate toBannerStatusModerate(TransportStatus transportStatus) {
        return BannersStatusmoderate.valueOf(transportStatus.toString());
    }

    public static PhrasesStatusmoderate toAdGroupStatusModerate(TransportStatus transportStatus) {
        return PhrasesStatusmoderate.valueOf(transportStatus.toString());
    }

    public static PromoactionsStatusmoderate toPromoactionStatusModerate(TransportStatus transportStatus) {
        return PromoactionsStatusmoderate.valueOf(transportStatus.toString());
    }

    public static BidsStatusmoderate toKeywordsStatusModerate(TransportStatus transportStatus) {
        return BidsStatusmoderate.valueOf(transportStatus.toString());
    }

    public static BannerTurbolandingsStatusmoderate toBannerTurbolandingsStatusmoderate(TransportStatus transportStatus) {
        return BannerTurbolandingsStatusmoderate.valueOf(transportStatus.toString());
    }

    public static BannerDisplayHrefsStatusmoderate toBannerDisplayHrefsStatusmoderate(TransportStatus transportStatus) {
        if (transportStatus == TransportStatus.New) {
            return BannerDisplayHrefsStatusmoderate.Ready; //Почему-то у отобр. урла (единственного) нет статуса New
        }

        return BannerDisplayHrefsStatusmoderate.valueOf(transportStatus.toString());
    }

    public static ModerateBannerPagesStatusmoderate toBannerPagesStatusModerate(TransportStatus transportStatus) {
        return ModerateBannerPagesStatusmoderate.valueOf(transportStatus.toString());
    }

    public static BannersStatussitelinksmoderate toBannersStatussitelinksmoderate(TransportStatus transportStatus) {
        return BannersStatussitelinksmoderate.valueOf(transportStatus.toString());
    }


    public static BannerImagesStatusmoderate toBannerImagesStatusmoderate(TransportStatus from) {
        return BannerImagesStatusmoderate.valueOf(from.toString());
    }

    public static BannerLogosStatusmoderate toBannerLogosStatusmoderate(TransportStatus from) {
        return BannerLogosStatusmoderate.valueOf(from.toString());
    }

    public static BannerButtonsStatusmoderate toBannerButtonsStatusmoderate(TransportStatus from) {
        return BannerButtonsStatusmoderate.valueOf(from.toString());
    }

    public static BannersPhoneflag toBannersPhoneflag(TransportStatus from) {
        return BannersPhoneflag.valueOf(from.toString());
    }

    public static PerfCreativesStatusmoderate toPerfCreativesStatusmoderate(TransportStatus transportStatus) {
        return PerfCreativesStatusmoderate.valueOf(transportStatus.toString());
    }

    public static BannersPerformanceStatusmoderate toBannersPerformanceStatusmoderate(TransportStatus transportStatus) {
        return BannersPerformanceStatusmoderate.valueOf(transportStatus.toString());
    }

    public static BannerMulticardSetsStatusmoderate toBannerMulticardSetsStatusModerate(TransportStatus transportStatus) {
        return BannerMulticardSetsStatusmoderate.valueOf(transportStatus.toString());
    }

    public static AdditionsItemCalloutsStatusmoderate toAdditionsItemCalloutsStatusmoderate(TransportStatus transportStatus) {
        return AdditionsItemCalloutsStatusmoderate.valueOf(transportStatus.toString());
    }

    public static MobileContentStatusiconmoderate toMobileContentStatusiconmoderate(TransportStatus transportStatus) {
        return MobileContentStatusiconmoderate.valueOf(transportStatus.toString());
    }

    public static CampaignsStatusmoderate toCampaignStatusmoderate(TransportStatus transportStatus) {
        return CampaignsStatusmoderate.valueOf(transportStatus.toString());
    }
}
